/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.constants;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import tech.thatgravyboat.playdate.Playdate;

public enum PlayerSkin implements StringRepresentable
{
    ALEX(Playdate.modId("textures/block/players/alex.png")),
    STEVE(Playdate.modId("textures/block/players/steve.png")),
    THATGRAVYBOAT(Playdate.modId("textures/block/players/thatgravyboat.png")),
    FROGIPHER(Playdate.modId("textures/block/players/frogipher.png"));

    private static final Map<String, PlayerSkin> MAP;
    public final ResourceLocation path;

    private PlayerSkin(ResourceLocation path) {
        this.path = path;
    }

    public boolean isDefault() {
        return this == ALEX || this == STEVE;
    }

    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static PlayerSkin getSkin(String name, PlayerSkin defaultSkin) {
        if (MAP.isEmpty()) {
            for (PlayerSkin value : PlayerSkin.values()) {
                MAP.put(value.name().toLowerCase(Locale.ROOT), value);
            }
        }
        return MAP.getOrDefault(name.toLowerCase(Locale.ROOT), defaultSkin);
    }

    static {
        MAP = new HashMap<String, PlayerSkin>();
    }
}

