/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import tech.thatgravyboat.playdate.common.blocks.toys.ToyBlock;
import tech.thatgravyboat.playdate.common.constants.PlushieEntity;

public class ToyEntity
extends Monster
implements IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final PlushieEntity plushie;
    private final Block block;

    public ToyEntity(EntityType<ToyEntity> entityType, Block block, Level world, PlushieEntity plushie) {
        super(entityType, world);
        this.plushie = plushie;
        this.block = block;
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        ((GroundPathNavigation)this.m_21573_()).m_148214_(true);
    }

    public PlushieEntity getPlushie() {
        return this.plushie;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new OcelotAttackGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_8119_() {
        ServerLevel server;
        Level level = this.f_19853_;
        if (level instanceof ServerLevel && (server = (ServerLevel)level).m_46461_()) {
            this.m_146870_();
            BlockPos blockPos = this.m_142538_();
            if (this.f_19853_.m_8055_(blockPos).m_60767_().m_76336_()) {
                this.f_19853_.m_46597_(blockPos, (BlockState)this.block.m_49966_().m_61124_((Property)ToyBlock.POSSESSED, (Comparable)Boolean.valueOf(true)));
            }
        }
        super.m_8119_();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation(event.isMoving() ? "walk" : "entity_idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

