/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.items;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import tech.thatgravyboat.playdate.common.constants.BalloonType;
import tech.thatgravyboat.playdate.common.entity.BalloonEntity;
import tech.thatgravyboat.playdate.common.registry.ModEntities;
import tech.thatgravyboat.playdate.common.registry.ModItems;
import tech.thatgravyboat.playdate.common.utils.Color;

public class BalloonItem
extends Item
implements DyeableLeatherItem {
    private final BalloonType type;

    public BalloonItem(BalloonType type, Item.Properties settings) {
        super(settings);
        this.type = type;
    }

    public int m_41121_(ItemStack stack) {
        return BalloonItem.isRainbow(stack) ? Color.RAINBOW.getRGBA() : super.m_41121_(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            BalloonEntity balloonEntity = (BalloonEntity)ModEntities.BALLOON.get().m_20655_(server, null, null, user, user.m_142538_().m_142082_(0, 3, 0), MobSpawnType.TRIGGERED, false, false);
            ItemStack stack = user.m_21120_(hand);
            CompoundTag nbt = stack.m_41783_();
            if (balloonEntity != null) {
                float length = nbt != null ? nbt.m_128457_("length") : 0.0f;
                balloonEntity.setColor(this.m_41121_(stack));
                balloonEntity.setRainbow(BalloonItem.isRainbow(stack));
                balloonEntity.setTexture(this.type);
                balloonEntity.setRopeLength(length + 2.0f);
                world.m_7967_((Entity)balloonEntity);
                balloonEntity.attachRope((Entity)user);
                user.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)user, (ItemStack)new ItemStack((ItemLike)ModItems.ROPE.get())));
            }
        }
        return super.m_7203_(world, user, hand);
    }

    private static boolean isRainbow(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128471_("rainbow") || stack.m_41786_().m_6111_().equals("jeb_");
    }
}

