/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.utils;

import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.util.FastColor;

public class Color {
    public static final Color RAINBOW = new Color(-65536);
    private int value;

    public Color(int value) {
        this.value = value;
    }

    public Color(int r, int g, int b, int a) {
        this.value = FastColor.ARGB32.m_13660_((int)a, (int)r, (int)g, (int)b);
    }

    public Color(float r, float g, float b, float a) {
        this.value = FastColor.ARGB32.m_13660_((int)((int)(a * 255.0f)), (int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(b * 255.0f)));
    }

    public int getRGBA() {
        return this.value;
    }

    public int getRed() {
        return FastColor.ARGB32.m_13665_((int)this.value);
    }

    public int getGreen() {
        return FastColor.ARGB32.m_13667_((int)this.value);
    }

    public int getBlue() {
        return FastColor.ARGB32.m_13669_((int)this.value);
    }

    public int getAlpha() {
        return FastColor.ARGB32.m_13655_((int)this.value);
    }

    public static void initRainbow() {
        new Timer().scheduleAtFixedRate((TimerTask)new ColorChange(), 0L, 40L);
    }

    static {
        Color.initRainbow();
    }

    private static class ColorChange
    extends TimerTask {
        private ColorChange() {
        }

        @Override
        public void run() {
            int r = RAINBOW.getRed();
            int g = RAINBOW.getGreen();
            int b = RAINBOW.getBlue();
            if (r > 0 && b == 0) {
                --r;
                ++g;
            }
            if (g > 0 && r == 0) {
                --g;
                ++b;
            }
            if (b > 0 && g == 0) {
                ++r;
                --b;
            }
            Color.RAINBOW.value = FastColor.ARGB32.m_13660_((int)255, (int)r, (int)g, (int)b);
        }
    }
}

