/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.healthbarplus.screens.sliders;

import com.minecraftserverzone.healthbarplus.screens.HostileMobScreen;
import com.minecraftserverzone.healthbarplus.screens.HostileMobScreen2;
import com.minecraftserverzone.healthbarplus.screens.NeutralMobScreen;
import com.minecraftserverzone.healthbarplus.screens.NeutralMobScreen2;
import com.minecraftserverzone.healthbarplus.screens.PassiveMobScreen;
import com.minecraftserverzone.healthbarplus.screens.PassiveMobScreen2;
import com.minecraftserverzone.healthbarplus.screens.PlayerOptionsScreen;
import com.minecraftserverzone.healthbarplus.screens.PlayerOptionsScreen2;
import com.minecraftserverzone.healthbarplus.screens.PlayerOptionsScreen3;
import com.minecraftserverzone.healthbarplus.screens.sliders.NewAbstractSlider;
import java.text.DecimalFormat;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class NewForgeSlider
extends NewAbstractSlider {
    protected class_2561 prefix;
    protected class_2561 suffix;
    protected double minValue;
    protected double maxValue;
    protected double stepSize;
    protected boolean drawString;
    private final DecimalFormat format;

    public NewForgeSlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean drawString) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)""), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = Math.abs(stepSize);
        this.value = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = class_3532.method_20390((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.updateMessage();
    }

    public NewForgeSlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, boolean drawString) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, 1.0, 0, drawString);
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void setValue(double value) {
        this.value = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.updateMessage();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
        this.setData();
    }

    @Override
    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        super.onDrag(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
        this.setData();
    }

    @Override
    public void onPress() {
    }

    public void setData() {
        if (class_310.method_1551().field_1755.getClass() == PlayerOptionsScreen.class) {
            PlayerOptionsScreen.setData();
        } else if (class_310.method_1551().field_1755.getClass() == PlayerOptionsScreen2.class) {
            PlayerOptionsScreen2.setData();
        } else if (class_310.method_1551().field_1755.getClass() == PlayerOptionsScreen3.class) {
            PlayerOptionsScreen3.setData();
        } else if (class_310.method_1551().field_1755.getClass() == HostileMobScreen.class) {
            HostileMobScreen.setData();
        } else if (class_310.method_1551().field_1755.getClass() == HostileMobScreen2.class) {
            HostileMobScreen2.setData();
        } else if (class_310.method_1551().field_1755.getClass() == NeutralMobScreen.class) {
            NeutralMobScreen.setData();
        } else if (class_310.method_1551().field_1755.getClass() == NeutralMobScreen2.class) {
            NeutralMobScreen2.setData();
        } else if (class_310.method_1551().field_1755.getClass() == PassiveMobScreen.class) {
            PassiveMobScreen.setData();
        } else if (class_310.method_1551().field_1755.getClass() == PassiveMobScreen2.class) {
            PassiveMobScreen2.setData();
        }
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.value + (double)(f / (float)(this.width - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.x + 4)) / (double)(this.width - 8));
    }

    private void setSliderValue(double value) {
        double oldValue = this.value;
        this.value = this.snapToNearest(value);
        if (!class_3532.method_20390((double)oldValue, (double)this.value)) {
            this.applyValue();
        }
        this.updateMessage();
    }

    private double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        }
        value = class_3532.method_16436((double)class_3532.method_15350((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? class_3532.method_15350((double)value, (double)this.maxValue, (double)this.minValue) : class_3532.method_15350((double)value, (double)this.minValue, (double)this.maxValue);
        return NewForgeSlider.map(value, this.minValue, this.maxValue, 0.0, 1.0);
    }

    public static double map(double p_144915_, double p_144916_, double p_144917_, double p_144918_, double p_144919_) {
        return NewForgeSlider.lerp(class_3532.method_15370((double)p_144915_, (double)p_144916_, (double)p_144917_), p_144918_, p_144919_);
    }

    public static double lerp(double p_14140_, double p_14141_, double p_14142_) {
        return p_14141_ + p_14140_ * (p_14142_ - p_14141_);
    }

    @Override
    protected void updateMessage() {
        if (this.drawString) {
            this.setMessage((class_2561)class_2561.method_43470((String)"").method_10852(this.prefix).method_27693(this.getValueString()).method_10852(this.suffix));
        } else {
            this.setMessage((class_2561)class_2561.method_43470((String)""));
        }
    }

    @Override
    protected void applyValue() {
    }
}

