/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftservezone.healthbarplus.screen;

import com.minecraftservezone.healthbarplus.screen.HostileMobScreen;
import com.minecraftservezone.healthbarplus.screen.HostileMobScreen2;
import com.minecraftservezone.healthbarplus.screen.NeutralMobScreen;
import com.minecraftservezone.healthbarplus.screen.NeutralMobScreen2;
import com.minecraftservezone.healthbarplus.screen.NewAbstractSlider;
import com.minecraftservezone.healthbarplus.screen.OptionsScreen;
import com.minecraftservezone.healthbarplus.screen.OptionsScreen2;
import com.minecraftservezone.healthbarplus.screen.OptionsScreen3;
import com.minecraftservezone.healthbarplus.screen.PassiveMobScreen;
import com.minecraftservezone.healthbarplus.screen.PassiveMobScreen2;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class NewForgeSlider
extends NewAbstractSlider {
    protected ITextComponent prefix;
    protected ITextComponent suffix;
    protected double minValue;
    protected double maxValue;
    protected double stepSize;
    protected boolean drawString;
    private final DecimalFormat format;

    public NewForgeSlider(int x, int y, int width, int height, ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean drawString) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent(""), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = Math.abs(stepSize);
        this.value = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = MathHelper.func_219806_b((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.updateMessage();
    }

    public NewForgeSlider(int x, int y, int width, int height, ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, double currentValue, boolean drawString) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, 1.0, 0, drawString);
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void setValue(double value) {
        this.value = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.updateMessage();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
        this.setData();
    }

    @Override
    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        super.onDrag(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
        this.setData();
    }

    public void setData() {
        if (Minecraft.func_71410_x().field_71462_r.getClass() == OptionsScreen.class) {
            OptionsScreen.setData();
        } else if (Minecraft.func_71410_x().field_71462_r.getClass() == OptionsScreen2.class) {
            OptionsScreen2.setData();
        } else if (Minecraft.func_71410_x().field_71462_r.getClass() == OptionsScreen3.class) {
            OptionsScreen3.setData();
        } else if (Minecraft.func_71410_x().field_71462_r.getClass() == HostileMobScreen.class) {
            HostileMobScreen.setData();
        } else if (Minecraft.func_71410_x().field_71462_r.getClass() == HostileMobScreen2.class) {
            HostileMobScreen2.setData();
        } else if (Minecraft.func_71410_x().field_71462_r.getClass() == NeutralMobScreen.class) {
            NeutralMobScreen.setData();
        } else if (Minecraft.func_71410_x().field_71462_r.getClass() == NeutralMobScreen2.class) {
            NeutralMobScreen2.setData();
        } else if (Minecraft.func_71410_x().field_71462_r.getClass() == PassiveMobScreen.class) {
            PassiveMobScreen.setData();
        } else if (Minecraft.func_71410_x().field_71462_r.getClass() == PassiveMobScreen2.class) {
            PassiveMobScreen2.setData();
        }
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.value + (double)(f / (float)(this.width - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.x + 4)) / (double)(this.width - 8));
    }

    private void setSliderValue(double value) {
        double oldValue = this.value;
        this.value = this.snapToNearest(value);
        if (!MathHelper.func_219806_b((double)oldValue, (double)this.value)) {
            this.applyValue();
        }
        this.updateMessage();
    }

    private double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0);
        }
        value = MathHelper.func_219803_d((double)MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? MathHelper.func_151237_a((double)value, (double)this.maxValue, (double)this.minValue) : MathHelper.func_151237_a((double)value, (double)this.minValue, (double)this.maxValue);
        return NewForgeSlider.map(value, this.minValue, this.maxValue, 0.0, 1.0);
    }

    public static double map(double p_144915_, double p_144916_, double p_144917_, double p_144918_, double p_144919_) {
        return NewForgeSlider.lerp(MathHelper.func_233020_c_((double)p_144915_, (double)p_144916_, (double)p_144917_), p_144918_, p_144919_);
    }

    public static double lerp(double p_14140_, double p_14141_, double p_14142_) {
        return p_14141_ + p_14140_ * (p_14142_ - p_14141_);
    }

    @Override
    protected void updateMessage() {
        if (this.drawString) {
            this.setMessage((ITextComponent)new StringTextComponent("").func_230529_a_(this.prefix).func_240702_b_(this.getValueString()).func_230529_a_(this.suffix));
        } else {
            this.setMessage((ITextComponent)new StringTextComponent(""));
        }
    }

    @Override
    protected void applyValue() {
    }
}

