/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftservezone.healthbarplus.setup.configs;

import net.minecraftforge.common.ForgeConfigSpec;

public final class ClientConfig {
    public final ForgeConfigSpec.IntValue[] PASSIVE_MOB_HP_BAR = new ForgeConfigSpec.IntValue[32];
    public final ForgeConfigSpec.IntValue[] NEUTRAL_MOB_HP_BAR = new ForgeConfigSpec.IntValue[32];
    public final ForgeConfigSpec.IntValue[] HOSTILE_MOB_HP_BAR = new ForgeConfigSpec.IntValue[32];
    public final ForgeConfigSpec.IntValue[] PLAYER_HUD_HEAD_HOLDER = new ForgeConfigSpec.IntValue[26];
    public final ForgeConfigSpec.IntValue[] PLAYER_HP_BAR = new ForgeConfigSpec.IntValue[32];
    public final ForgeConfigSpec.ConfigValue<String> BLACKLIST;

    ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        ClientConfig.initMobHpbar(builder, "Passive Mob Hp bar", "passive", this.PASSIVE_MOB_HP_BAR, 12, -100, -10, 80, 255, 255, 255, 255, 0, 160, 0, 255, 250, 140, 130, 255, 255, 255, 255, 174, 10, 255, 0, 0, 255);
        ClientConfig.initMobHpbar(builder, "Neutral Mob Hp bar", "neutral", this.NEUTRAL_MOB_HP_BAR, 25, -105, -20, 80, 153, 138, 151, 255, 255, 255, 0, 255, 177, 130, 130, 255, 0, 0, 0, 156, 0, 0, 0, 0, 0);
        ClientConfig.initMobHpbar(builder, "Hostile Mob Hp bar", "hostile", this.HOSTILE_MOB_HP_BAR, 0, -110, -35, 80, 255, 255, 0, 255, 151, 0, 0, 255, 30, 0, 0, 255, 255, 255, 255, 200, 0, 0, 0, 0, 0);
        ClientConfig.initMobHpbar(builder, "Player HUD Hp bar", "player", this.PLAYER_HP_BAR, 12, 0, 0, 100, 255, 255, 255, 255, 255, 0, 0, 255, 249, 140, 130, 176, 240, 233, 255, 186, 10, 255, 120, 165, 247);
        ClientConfig.initPlayerHud(builder, "Player Head Holder", "player_head_holder", this.PLAYER_HUD_HEAD_HOLDER, 2, 167, 100, 92, 255, 0, 0, 0, 165, 17, 96, 255, 0, 255);
        this.BLACKLIST = builder.comment("\nList for the mobs that should not be displayed, put a comma (,) between the registered names!").define("blacklist", (Object)"minecraft:ender_dragon");
        builder.pop();
    }

    public static void initMobHpbar(ForgeConfigSpec.Builder builder, String name, String pushname, ForgeConfigSpec.IntValue[] array, int frameType, int posx, int posy, int scale, int framered, int framegreen, int frameblue, int frameopacity, int hpred, int hpgreen, int hpblue, int hpopacity, int hpbgred, int hpbggreen, int hpbgblue, int hpbgopacity, int textred, int textgreen, int textblue, int textopacity, int frame2type, int frame2red, int frame2green, int frame2blue, int frame2opacity) {
        builder.comment(name).push(pushname);
        array[0] = builder.comment("Health Bar Type").translation("healthbarplus" + pushname + ".config.type").defineInRange("type", frameType, 0, Integer.MAX_VALUE);
        array[1] = builder.comment("X Position").translation("healthbarplus" + pushname + ".config.xpos").defineInRange("x-pos", posx, Integer.MIN_VALUE, Integer.MAX_VALUE);
        array[2] = builder.comment("Y Position").translation("healthbarplus" + pushname + ".config.ypos").defineInRange("y-pos", posy, Integer.MIN_VALUE, Integer.MAX_VALUE);
        array[3] = builder.comment("scale").translation("healthbarplus" + pushname + ".config.scale").defineInRange("scale", scale, 0, Integer.MAX_VALUE);
        array[4] = builder.comment("Render Distance").translation("healthbarplus" + pushname + ".config.render_distance").defineInRange("render-distance", 1500, 0, Integer.MAX_VALUE);
        array[5] = builder.comment("Frame Red Color").translation("healthbarplus" + pushname + ".config.frame_red").defineInRange("frame_red", framered, 0, Integer.MAX_VALUE);
        array[6] = builder.comment("Frame Green Color").translation("healthbarplus" + pushname + ".config.frame_green").defineInRange("frame_green", framegreen, 0, Integer.MAX_VALUE);
        array[7] = builder.comment("Frame Blue Color").translation("healthbarplus" + pushname + ".config.frame_blue").defineInRange("frame_blue", frameblue, 0, Integer.MAX_VALUE);
        array[8] = builder.comment("Frame Opacity").translation("healthbarplus" + pushname + ".config.frame_opacity").defineInRange("frame_opacity", frameopacity, 0, Integer.MAX_VALUE);
        array[9] = builder.comment("Hp Red Color").translation("healthbarplus" + pushname + ".config.hp_red").defineInRange("hp_red", hpred, 0, Integer.MAX_VALUE);
        array[10] = builder.comment("Hp Green Color").translation("healthbarplus" + pushname + ".config.hp_green").defineInRange("blue_green", hpgreen, 0, Integer.MAX_VALUE);
        array[11] = builder.comment("Hp Blue Color").translation("healthbarplus" + pushname + ".config.hp_blue").defineInRange("hp_blue", hpblue, 0, Integer.MAX_VALUE);
        array[12] = builder.comment("Hp Opacity").translation("healthbarplus" + pushname + ".config.hp_opacity").defineInRange("hp_opacity", hpopacity, 0, Integer.MAX_VALUE);
        array[13] = builder.comment("Hp Bg Red Color").translation("healthbarplus" + pushname + ".config.hp_bg_red").defineInRange("hp_bg_red", hpbgred, 0, Integer.MAX_VALUE);
        array[14] = builder.comment("Hp Bg Green Color").translation("healthbarplus" + pushname + ".config.hp_bg_green").defineInRange("hp_bg_green", hpbggreen, 0, Integer.MAX_VALUE);
        array[15] = builder.comment("Hp Bg Blue Color").translation("healthbarplus" + pushname + ".config.hp_bg_blue").defineInRange("hp_bg_blue", hpbgblue, 0, Integer.MAX_VALUE);
        array[16] = builder.comment("Hp Bg Opacity").translation("healthbarplus" + pushname + ".config.hp_bg_opacity").defineInRange("hp_bg_opacity", hpbgopacity, 0, Integer.MAX_VALUE);
        array[17] = builder.comment("Hp Text Red").translation("healthbarplus" + pushname + ".config.text_red").defineInRange("text_red", textred, 0, Integer.MAX_VALUE);
        array[18] = builder.comment("Hp Text Green").translation("healthbarplus" + pushname + ".config.text_green").defineInRange("text_green", textgreen, 0, Integer.MAX_VALUE);
        array[19] = builder.comment("Hp Text Blue").translation("healthbarplus" + pushname + ".config.text_blue").defineInRange("text_blue", textblue, 0, Integer.MAX_VALUE);
        array[20] = builder.comment("Hp Text Opacity").translation("healthbarplus" + pushname + ".config.text_opacity").defineInRange("text_opacity", textopacity, 0, Integer.MAX_VALUE);
        array[21] = builder.comment("Hp toggle all").translation("healthbarplus" + pushname + ".config.toggle_all").defineInRange("toggle_all", 0, 0, 1);
        array[22] = builder.comment("Hp Bg type").translation("healthbarplus" + pushname + ".config.bg_type").defineInRange("bg_type", 0, 0, Integer.MAX_VALUE);
        array[23] = builder.comment("Hp type").translation("healthbarplus" + pushname + ".config.hp_type").defineInRange("hp_type", 0, 0, Integer.MAX_VALUE);
        array[24] = builder.comment("Text x position").translation("healthbarplus" + pushname + ".config.text_x").defineInRange("text_x", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        array[25] = builder.comment("Text y position").translation("healthbarplus" + pushname + ".config.text_y").defineInRange("text_y", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        array[26] = builder.comment("Text Size").translation("healthbarplus" + pushname + ".config.text_scale").defineInRange("text_scale", 100, 0, Integer.MAX_VALUE);
        array[27] = builder.comment("Frame 2 type").translation("healthbarplus" + pushname + ".config.frame2_type").defineInRange("frame2_type", frame2type, 0, Integer.MAX_VALUE);
        array[28] = builder.comment("Frame 2 red color").translation("healthbarplus" + pushname + ".config.frame2_red_color").defineInRange("frame2_red_color", frame2red, 0, Integer.MAX_VALUE);
        array[29] = builder.comment("Frame 2 green color").translation("healthbarplus" + pushname + ".config.frame2_green_color").defineInRange("frame2_green_color", frame2green, 0, Integer.MAX_VALUE);
        array[30] = builder.comment("Frame 2 blue color").translation("healthbarplus" + pushname + ".config.frame2_blue_color").defineInRange("frame2_blue_color", frame2blue, 0, Integer.MAX_VALUE);
        array[31] = builder.comment("Frame 2 Opacity").translation("healthbarplus" + pushname + ".config.frame2_opacity").defineInRange("frame2_opacity", frame2opacity, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    public static void initPlayerHud(ForgeConfigSpec.Builder builder, String name, String pushname, ForgeConfigSpec.IntValue[] array, int frametype, int framered, int framegreen, int frameblue, int frameopacity, int bgred, int bggreen, int bgblue, int bgopacity, int frame2type, int frame2red, int frame2green, int frame2blue, int frame2opacity) {
        builder.comment(name).push(pushname);
        array[0] = builder.comment("HUD Frame Type").translation("healthbarplus" + pushname + ".config.type").defineInRange("type", frametype, 0, Integer.MAX_VALUE);
        array[1] = builder.comment("X Position").translation("healthbarplus" + pushname + ".config.xpos").defineInRange("x-pos", -195, Integer.MIN_VALUE, Integer.MAX_VALUE);
        array[2] = builder.comment("Y Position").translation("healthbarplus" + pushname + ".config.ypos").defineInRange("y-pos", -92, Integer.MIN_VALUE, Integer.MAX_VALUE);
        array[3] = builder.comment("scale").translation("healthbarplus" + pushname + ".config.scale").defineInRange("scale", 96, 0, Integer.MAX_VALUE);
        array[4] = builder.comment("Render Distance").translation("healthbarplus" + pushname + ".config.render_distance").defineInRange("render-distance", 2000, 0, Integer.MAX_VALUE);
        array[5] = builder.comment("Frame Red Color").translation("healthbarplus" + pushname + ".config.frame_red").defineInRange("frame_red", framered, 0, Integer.MAX_VALUE);
        array[6] = builder.comment("Frame Green Color").translation("healthbarplus" + pushname + ".config.frame_green").defineInRange("frame_green", framegreen, 0, Integer.MAX_VALUE);
        array[7] = builder.comment("Frame Blue Color").translation("healthbarplus" + pushname + ".config.frame_blue").defineInRange("frame_blue", frameblue, 0, Integer.MAX_VALUE);
        array[8] = builder.comment("Frame Opacity").translation("healthbarplus" + pushname + ".config.frame_opacity").defineInRange("frame_opacity", frameopacity, 0, Integer.MAX_VALUE);
        array[9] = builder.comment("Bg Red Color").translation("healthbarplus" + pushname + ".config.bg_red").defineInRange("bg_red", bgred, 0, Integer.MAX_VALUE);
        array[10] = builder.comment("Bg Green Color").translation("healthbarplus" + pushname + ".config.bg_green").defineInRange("bg_green", bggreen, 0, Integer.MAX_VALUE);
        array[11] = builder.comment("Bg Blue Color").translation("healthbarplus" + pushname + ".config.bg_blue").defineInRange("bg_blue", bgblue, 0, Integer.MAX_VALUE);
        array[12] = builder.comment("Bg Opacity").translation("healthbarplus" + pushname + ".config.bg_opacity").defineInRange("bg_opacity", bgopacity, 0, Integer.MAX_VALUE);
        array[13] = builder.comment("Animate Head").translation("healthbarplus" + pushname + ".config.animate_head").defineInRange("animate_head", 0, 0, 1);
        array[14] = builder.comment("Toggle head").translation("healthbarplus" + pushname + ".config.toggle_head").defineInRange("toggle_head", 0, 0, 1);
        array[15] = builder.comment("Toggle all").translation("healthbarplus" + pushname + ".config.toggle_all").defineInRange("toggle_all", 0, 0, 1);
        array[16] = builder.comment("Head X Position").translation("healthbarplus" + pushname + ".config.hxpos").defineInRange("h-x-pos", -242, Integer.MIN_VALUE, Integer.MAX_VALUE);
        array[17] = builder.comment("Head Y Position").translation("healthbarplus" + pushname + ".config.hypos").defineInRange("h-y-pos", -115, Integer.MIN_VALUE, Integer.MAX_VALUE);
        array[18] = builder.comment("Head Size").translation("healthbarplus" + pushname + ".config.head_size").defineInRange("head_size", 43, 0, Integer.MAX_VALUE);
        array[19] = builder.comment("HUD Bg Type").translation("healthbarplus" + pushname + ".config.bgtype").defineInRange("bgtype", 0, 0, Integer.MAX_VALUE);
        array[20] = builder.comment("Layer 0, 1 or 2").translation("healthbarplus" + pushname + ".config.layer").defineInRange("layer", 0, 0, Integer.MAX_VALUE);
        array[21] = builder.comment("Frame 2 type").translation("healthbarplus" + pushname + ".config.frame2_type").defineInRange("frame2_type", frame2type, 0, Integer.MAX_VALUE);
        array[22] = builder.comment("Frame 2 red color").translation("healthbarplus" + pushname + ".config.frame2_red_color").defineInRange("frame2_red_color", frame2red, 0, Integer.MAX_VALUE);
        array[23] = builder.comment("Frame 2 red color").translation("healthbarplus" + pushname + ".config.frame2_green_color").defineInRange("frame2_green_color", frame2green, 0, Integer.MAX_VALUE);
        array[24] = builder.comment("Frame 2 blue color").translation("healthbarplus" + pushname + ".config.frame2_blue_color").defineInRange("frame2_blue_color", frame2blue, 0, Integer.MAX_VALUE);
        array[25] = builder.comment("Frame 2 Opacity").translation("healthbarplus" + pushname + ".config.frame2_opacity").defineInRange("frame2_opacity", frame2opacity, 0, Integer.MAX_VALUE);
        builder.pop();
    }
}

