/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.client.immersive;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.blf02.immersivemc.client.immersive.Immersives;
import net.blf02.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import net.blf02.immersivemc.client.immersive.info.InfoTriggerHitboxes;
import net.blf02.immersivemc.client.model.Cube1x1;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.vr.VRPlugin;
import net.blf02.immersivemc.common.vr.VRPluginVerify;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_761;
import net.minecraft.class_809;

public abstract class AbstractImmersive<I extends AbstractImmersiveInfo> {
    protected final List<I> infos;
    public final int maxImmersives;
    protected static final Cube1x1 cubeModel = new Cube1x1(class_310.method_1551().method_31974().method_32072(Cube1x1.LAYER_LOCATION));
    protected boolean forceDisableItemGuide = false;

    public AbstractImmersive(int maxImmersives) {
        Immersives.IMMERSIVES.add(this);
        this.maxImmersives = maxImmersives;
        this.infos = new ArrayList<I>(maxImmersives > 0 ? maxImmersives + 1 : 16);
    }

    public boolean hitboxesAvailable(AbstractImmersiveInfo info) {
        return true;
    }

    public abstract boolean shouldRender(I var1, boolean var2);

    protected abstract void render(I var1, class_4587 var2, boolean var3);

    protected abstract boolean enabledInConfig();

    protected abstract boolean slotShouldRenderHelpHitbox(I var1, int var2);

    public abstract boolean shouldTrack(class_2338 var1, class_2680 var2, class_2586 var3, class_1937 var4);

    public abstract void trackObject(class_2338 var1, class_2680 var2, class_2586 var3, class_1937 var4);

    public abstract AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton();

    protected abstract void initInfo(I var1);

    public void onAnyRightClick(AbstractImmersiveInfo info) {
    }

    public boolean isVROnly() {
        return false;
    }

    public abstract void handleRightClick(AbstractImmersiveInfo var1, class_1657 var2, int var3, class_1268 var4);

    public void handleTriggerHitboxRightClick(InfoTriggerHitboxes info, class_1657 player, int hitboxNum) {
    }

    public void onRemove(I info) {
    }

    protected boolean slotHelpBoxIsGreen(I info, int slotNum) {
        return ((AbstractImmersiveInfo)info).slotHovered == slotNum;
    }

    public void tick(I info, boolean isInVR) {
        if (this.enabledInConfig()) {
            if (!((AbstractImmersiveInfo)info).initCompleted) {
                this.initInfo(info);
                ((AbstractImmersiveInfo)info).initCompleted = true;
            }
            if (class_310.method_1551().field_1687 != null && this.shouldTrack(((AbstractImmersiveInfo)info).getBlockPosition(), class_310.method_1551().field_1687.method_8320(((AbstractImmersiveInfo)info).getBlockPosition()), class_310.method_1551().field_1687.method_8321(((AbstractImmersiveInfo)info).getBlockPosition()), (class_1937)class_310.method_1551().field_1687)) {
                this.doTick(info, isInVR);
                ((AbstractImmersiveInfo)info).setInputSlots();
            } else {
                ((AbstractImmersiveInfo)info).remove();
            }
        }
    }

    public int getCooldownVR() {
        return 12;
    }

    public int getCooldownDesktop() {
        return 8;
    }

    protected void doTick(I info, boolean isInVR) {
        if (((AbstractImmersiveInfo)info).getItemTransitionCountdown() > 1 && ((AbstractImmersiveInfo)info).getTicksLeft() > 20) {
            ((AbstractImmersiveInfo)info).changeItemTransitionCountdown(-1);
        } else if (((AbstractImmersiveInfo)info).getItemTransitionCountdown() < 20 && ((AbstractImmersiveInfo)info).getTicksLeft() <= 20) {
            ((AbstractImmersiveInfo)info).changeItemTransitionCountdown(1);
        }
        if (((AbstractImmersiveInfo)info).getTicksLeft() > 0) {
            ((AbstractImmersiveInfo)info).changeTicksLeft(-1);
        }
        ++((AbstractImmersiveInfo)info).ticksActive;
    }

    public void doRender(I info, class_4587 stack, boolean isInVR) {
        if (this.shouldRender(info, isInVR)) {
            try {
                this.render(info, stack, isInVR);
                if (ActiveConfig.showPlacementGuide && !this.forceDisableItemGuide) {
                    for (int i = 0; i < ((AbstractImmersiveInfo)info).getInputSlots().length; ++i) {
                        if (!this.slotShouldRenderHelpHitbox(info, i)) continue;
                        class_238 itemBox = ((AbstractImmersiveInfo)info).getInputSlots()[i];
                        class_238 toShow = itemBox.method_989(0.0, itemBox.method_17940() / 2.0, 0.0);
                        this.renderItemGuide(stack, toShow, 0.2f, this.slotHelpBoxIsGreen(info, i));
                    }
                }
            }
            catch (NullPointerException | ConcurrentModificationException runtimeException) {
                // empty catch block
            }
        }
    }

    public List<I> getTrackedObjects() {
        return this.infos;
    }

    public void noInfosTick() {
    }

    public void renderItem(class_1799 item, class_4587 stack, class_243 pos, float size, class_2350 facing, class_238 hitbox, boolean renderItemCounts) {
        this.renderItem(item, stack, pos, size, facing, null, hitbox, renderItemCounts, -1);
    }

    public void renderItem(class_1799 item, class_4587 stack, class_243 pos, float size, class_2350 facing, class_2350 upDown, class_238 hitbox, boolean renderItemCounts, int spinDegrees) {
        class_4184 renderInfo = class_310.method_1551().field_1773.method_19418();
        if (item != null && item != class_1799.field_8037 && pos != null) {
            stack.method_22903();
            stack.method_22904(-renderInfo.method_19326().field_1352 + pos.field_1352, -renderInfo.method_19326().field_1351 + pos.field_1351, -renderInfo.method_19326().field_1350 + pos.field_1350);
            stack.method_22905(size, size, size);
            class_243 textPos = pos;
            int degreesRotation = 0;
            if (spinDegrees > -1) {
                degreesRotation = spinDegrees;
            } else if (facing == class_2350.field_11039) {
                degreesRotation = 90;
            } else if (facing == class_2350.field_11035) {
                degreesRotation = 180;
            } else if (facing == class_2350.field_11034) {
                degreesRotation = 270;
            }
            int upDownRot = 0;
            if (upDown == class_2350.field_11036) {
                upDownRot = 90;
                textPos = textPos.method_1031(0.0, 0.15, 0.0);
            } else if (upDown == class_2350.field_11033) {
                upDownRot = 270;
                textPos = textPos.method_1031(0.0, -0.15, 0.0);
            } else if (facing == class_2350.field_11039) {
                textPos = textPos.method_1031(-0.15, 0.0, 0.0);
            } else if (facing == class_2350.field_11035) {
                textPos = textPos.method_1031(0.0, 0.0, 0.15);
            } else if (facing == class_2350.field_11034) {
                textPos = textPos.method_1031(0.15, 0.0, 0.0);
            } else if (facing == class_2350.field_11043) {
                textPos = textPos.method_1031(0.0, 0.0, -0.15);
            } else if (facing == null) {
                stack.method_22907(class_310.method_1551().method_1561().method_24197());
                stack.method_22907(class_1160.field_20705.method_23214(180.0f));
                class_243 textMove = VRPluginVerify.hasAPI && VRPluginVerify.clientInVR ? VRPlugin.API.getRenderVRPlayer().getHMD().getLookAngle() : class_310.method_1551().field_1724.method_5720();
                textMove = textMove.method_18805(-0.05, -0.05, -0.05);
                textPos = textPos.method_1019(textMove);
            }
            if (facing != null) {
                stack.method_22907(class_1160.field_20705.method_23214((float)degreesRotation));
                stack.method_22907(class_1160.field_20703.method_23214((float)upDownRot));
            }
            class_809.class_811 type = facing == null ? class_809.class_811.field_4318 : class_809.class_811.field_4319;
            class_310.method_1551().method_1480().method_23178(item, type, 0xF000F0, class_4608.field_21444, stack, (class_4597)class_310.method_1551().method_22940().method_23000(), 0);
            stack.method_22909();
            if (renderItemCounts && item.method_7947() > 1) {
                this.renderText((class_2561)new class_2585(String.valueOf(item.method_7947())), stack, textPos, facing == null ? 0.0025f : 0.01f);
            }
        }
        this.renderHitbox(stack, hitbox, pos);
    }

    protected void renderItemGuide(class_4587 stack, class_238 hitbox, float alpha, boolean isGreen) {
        if (hitbox != null) {
            class_4184 renderInfo = class_310.method_1551().field_1773.method_19418();
            class_243 pos = hitbox.method_1005();
            stack.method_22903();
            stack.method_22904(-renderInfo.method_19326().field_1352 + pos.field_1352, -renderInfo.method_19326().field_1351 + pos.field_1351, -renderInfo.method_19326().field_1350 + pos.field_1350);
            class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
            cubeModel.render(stack, buffer.getBuffer(class_1921.method_23580((class_2960)Cube1x1.textureLocation)), 0.0f, 1.0f, isGreen ? 0.0f : 1.0f, alpha, (float)(hitbox.method_995() / 2.0));
            stack.method_22909();
        }
    }

    protected void renderHitbox(class_4587 stack, class_238 hitbox, class_243 pos) {
        this.renderHitbox(stack, hitbox, pos, false);
    }

    protected void renderHitbox(class_4587 stack, class_238 hitbox, class_243 pos, boolean alwaysRender) {
        AbstractImmersive.renderHitbox(stack, hitbox, pos, alwaysRender, 1.0f, 1.0f, 1.0f);
    }

    public static void renderHitbox(class_4587 stack, class_238 hitbox, class_243 pos, boolean alwaysRender, float red, float green, float blue) {
        if ((class_310.method_1551().method_1561().method_3958() || alwaysRender) && hitbox != null && pos != null) {
            class_4184 renderInfo = class_310.method_1551().field_1773.method_19418();
            stack.method_22903();
            stack.method_22904(-renderInfo.method_19326().field_1352 + pos.field_1352, -renderInfo.method_19326().field_1351 + pos.field_1351, -renderInfo.method_19326().field_1350 + pos.field_1350);
            class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
            class_761.method_22982((class_4587)stack, (class_4588)buffer.getBuffer((class_1921)class_1921.field_21695), (class_238)hitbox.method_989(-pos.field_1352, -pos.field_1351, -pos.field_1350), (float)red, (float)green, (float)blue, (float)1.0f);
            stack.method_22909();
        }
    }

    public void renderText(class_2561 text, class_4587 stack, class_243 pos) {
        this.renderText(text, stack, pos, 0.02f);
    }

    public void renderText(class_2561 text, class_4587 stack, class_243 pos, float textSize) {
        class_4184 renderInfo = class_310.method_1551().field_1773.method_19418();
        stack.method_22903();
        stack.method_22904(-renderInfo.method_19326().field_1352 + pos.field_1352, -renderInfo.method_19326().field_1351 + pos.field_1351, -renderInfo.method_19326().field_1350 + pos.field_1350);
        stack.method_22907(renderInfo.method_23767());
        stack.method_22905(-textSize, -textSize, -textSize);
        class_327 font = class_310.method_1551().field_1772;
        float size = (float)(-font.method_27525((class_5348)text)) / 2.0f;
        font.method_30882(text, size, 0.0f, -1, false, stack.method_23760().method_23761(), (class_4597)class_310.method_1551().method_22940().method_23000(), false, 0, 0xF000F0);
        stack.method_22909();
    }

    public class_2350 getLeftOfDirection(class_2350 forward) {
        if (forward == class_2350.field_11036 || forward == class_2350.field_11033) {
            throw new IllegalArgumentException("Direction cannot be up or down!");
        }
        if (forward == class_2350.field_11043) {
            return class_2350.field_11039;
        }
        if (forward == class_2350.field_11039) {
            return class_2350.field_11035;
        }
        if (forward == class_2350.field_11035) {
            return class_2350.field_11034;
        }
        return class_2350.field_11043;
    }

    public class_243 getDirectlyInFront(class_2350 forwardFromBlock, class_2338 pos) {
        if (forwardFromBlock == class_2350.field_11035) {
            class_2338 front = pos.method_10093(forwardFromBlock);
            return new class_243((double)front.method_10263(), (double)front.method_10264(), (double)front.method_10260());
        }
        if (forwardFromBlock == class_2350.field_11039) {
            class_2338 front = pos;
            return new class_243((double)front.method_10263(), (double)front.method_10264(), (double)front.method_10260());
        }
        if (forwardFromBlock == class_2350.field_11043) {
            class_2338 front = pos.method_10093(class_2350.field_11034);
            return new class_243((double)front.method_10263(), (double)front.method_10264(), (double)front.method_10260());
        }
        if (forwardFromBlock == class_2350.field_11034) {
            class_2338 front = pos.method_10093(class_2350.field_11035).method_10093(class_2350.field_11034);
            return new class_243((double)front.method_10263(), (double)front.method_10264(), (double)front.method_10260());
        }
        throw new IllegalArgumentException("Furnaces can't point up or down?!?!");
    }

    public class_243 getTopCenterOfBlock(class_2338 pos) {
        return class_243.method_26410((class_2382)pos, (double)1.0);
    }

    public class_2350 getForwardFromPlayer(class_1657 player) {
        return player.method_5735().method_10153();
    }

    public class_238 createHitbox(class_243 pos, float size) {
        return new class_238(pos.field_1352 - (double)size, pos.field_1351 - (double)size, pos.field_1350 - (double)size, pos.field_1352 + (double)size, pos.field_1351 + (double)size, pos.field_1350 + (double)size);
    }

    public class_243[] get3x3HorizontalGrid(class_2338 blockPos, double spacing) {
        return this.get3x3HorizontalGrid(blockPos, spacing, this.getForwardFromPlayer((class_1657)class_310.method_1551().field_1724));
    }

    public class_243[] get3x3HorizontalGrid(class_2338 blockPos, double spacing, class_2350 blockForward) {
        class_243 pos = this.getTopCenterOfBlock(blockPos);
        class_2350 left = this.getLeftOfDirection(blockForward);
        class_243 leftOffset = new class_243((double)left.method_10163().method_10263() * -spacing, 0.0, (double)left.method_10163().method_10260() * -spacing);
        class_243 rightOffset = new class_243((double)left.method_10163().method_10263() * spacing, 0.0, (double)left.method_10163().method_10260() * spacing);
        class_243 topOffset = new class_243((double)blockForward.method_10163().method_10263() * -spacing, 0.0, (double)blockForward.method_10163().method_10260() * -spacing);
        class_243 botOffset = new class_243((double)blockForward.method_10163().method_10263() * spacing, 0.0, (double)blockForward.method_10163().method_10260() * spacing);
        return new class_243[]{pos.method_1019(leftOffset).method_1019(topOffset), pos.method_1019(topOffset), pos.method_1019(rightOffset).method_1019(topOffset), pos.method_1019(leftOffset), pos, pos.method_1019(rightOffset), pos.method_1019(leftOffset).method_1019(botOffset), pos.method_1019(botOffset), pos.method_1019(rightOffset).method_1019(botOffset)};
    }

    public class_243[] get3x3VerticalGrid(class_2338 blockPos, double spacing) {
        class_243 posBotLeft = this.getDirectlyInFront(this.getForwardFromPlayer((class_1657)class_310.method_1551().field_1724), blockPos);
        class_2350 left = this.getLeftOfDirection(this.getForwardFromPlayer((class_1657)class_310.method_1551().field_1724));
        class_243 pos = posBotLeft.method_1031((double)left.method_10163().method_10263() * 0.5, 0.5, (double)left.method_10163().method_10260() * 0.5);
        class_243 leftOffset = new class_243((double)left.method_10163().method_10263() * -spacing, 0.0, (double)left.method_10163().method_10260() * -spacing);
        class_243 rightOffset = new class_243((double)left.method_10163().method_10263() * spacing, 0.0, (double)left.method_10163().method_10260() * spacing);
        class_243 upOffset = new class_243(0.0, spacing, 0.0);
        class_243 downOffset = new class_243(0.0, -spacing, 0.0);
        return new class_243[]{pos.method_1019(leftOffset).method_1019(upOffset), pos.method_1019(upOffset), pos.method_1019(rightOffset).method_1019(upOffset), pos.method_1019(leftOffset), pos, pos.method_1019(rightOffset), pos.method_1019(leftOffset).method_1019(downOffset), pos.method_1019(downOffset), pos.method_1019(rightOffset).method_1019(downOffset)};
    }
}

