/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.client.immersive;

import java.util.Objects;
import net.blf02.immersivemc.client.immersive.AbstractImmersive;
import net.blf02.immersivemc.client.immersive.AbstractWorldStorageImmersive;
import net.blf02.immersivemc.client.immersive.Immersives;
import net.blf02.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import net.blf02.immersivemc.client.immersive.info.AbstractWorldStorageInfo;
import net.blf02.immersivemc.client.immersive.info.AnvilInfo;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.packet.InteractPacket;
import net.blf02.immersivemc.common.storage.AnvilStorage;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public class ImmersiveAnvil
extends AbstractWorldStorageImmersive<AnvilInfo> {
    protected final double dist = 0.3333333333333333;

    public ImmersiveAnvil() {
        super(1);
    }

    @Override
    protected void initInfo(AnvilInfo info) {
        this.setHitboxes(info);
    }

    protected void setHitboxes(AnvilInfo info) {
        Objects.requireNonNull(class_310.method_1551().field_1724);
        Objects.requireNonNull(class_310.method_1551().field_1687);
        class_2680 anvil = class_310.method_1551().field_1687.method_8320(info.getBlockPosition());
        info.isReallyAnvil = this.isAnvil(anvil);
        class_2350 facing = info.isReallyAnvil ? (class_2350)anvil.method_11654((class_2769)class_2199.field_9883) : this.getForwardFromPlayer((class_1657)class_310.method_1551().field_1724).method_10160();
        info.renderDirection = facing.method_10170();
        class_2382 temp = facing.method_10153().method_10163();
        class_243 facingOppositeNormal = new class_243((double)temp.method_10263(), (double)temp.method_10264(), (double)temp.method_10260());
        temp = facing.method_10163();
        class_243 facingNormal = new class_243((double)temp.method_10263(), (double)temp.method_10264(), (double)temp.method_10260());
        class_243 middle = this.getTopCenterOfBlock(info.getBlockPosition());
        class_243 left = middle.method_1019(facingOppositeNormal.method_18805(0.3333333333333333, 0.3333333333333333, 0.3333333333333333));
        class_243 right = middle.method_1019(facingNormal.method_18805(0.3333333333333333, 0.3333333333333333, 0.3333333333333333));
        info.setPosition(0, left);
        info.setPosition(1, middle);
        info.setPosition(2, right);
        info.textPos = info.getPosition(1).method_1031(0.0, 0.5, 0.0);
        float hitboxSize = 0.16666667f;
        info.setHitbox(0, this.createHitbox(left, hitboxSize));
        info.setHitbox(1, this.createHitbox(middle, hitboxSize));
        info.setHitbox(2, this.createHitbox(right, hitboxSize));
        info.lastDir = facing;
    }

    @Override
    protected void doTick(AnvilInfo info, boolean isInVR) {
        class_2350 facing;
        super.doTick(info, isInVR);
        Objects.requireNonNull(class_310.method_1551().field_1724);
        Objects.requireNonNull(class_310.method_1551().field_1687);
        if (info.isReallyAnvil) {
            class_2680 anvil = class_310.method_1551().field_1687.method_8320(info.getBlockPosition());
            facing = (class_2350)anvil.method_11654((class_2769)class_2199.field_9883);
        } else {
            facing = this.getForwardFromPlayer((class_1657)class_310.method_1551().field_1724).method_10160();
        }
        if (facing != info.lastDir) {
            this.setHitboxes(info);
        }
    }

    @Override
    public boolean shouldRender(AnvilInfo info, boolean isInVR) {
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        class_638 level = class_310.method_1551().field_1687;
        return level != null && level.method_8320(info.getBlockPosition().method_10084()).method_26215() && info.readyToRender();
    }

    @Override
    protected void render(AnvilInfo info, class_4587 stack, boolean isInVR) {
        float itemSize = 0.33333334f / (float)info.getItemTransitionCountdown();
        if (info.isReallyAnvil && info.anvilCost > 0) {
            this.renderText((class_2561)new class_2585(class_1074.method_4662((String)"immersivemc.immersive.anvil.levels_needed", (Object[])new Object[]{info.anvilCost})), stack, info.textPos);
        }
        for (int i = 0; i <= 2; ++i) {
            float renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
            this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, info.renderDirection, class_2350.field_11036, info.getHitbox(i), false, -1);
        }
    }

    @Override
    protected boolean enabledInConfig() {
        return ActiveConfig.useAnvilImmersion;
    }

    @Override
    public void processStorageFromNetwork(AbstractWorldStorageInfo wInfo, ImmersiveStorage storageIn) {
        AnvilInfo info = (AnvilInfo)wInfo;
        info.items = storageIn.items;
        AnvilStorage aStorage = (AnvilStorage)storageIn;
        info.anvilCost = aStorage.xpLevels;
    }

    @Override
    public AnvilInfo getNewInfo(class_2338 pos) {
        return new AnvilInfo(pos, this.getTickTime());
    }

    @Override
    public int getTickTime() {
        return 120;
    }

    @Override
    protected boolean slotShouldRenderHelpHitbox(AnvilInfo info, int slotNum) {
        return info.items[slotNum] == null || info.items[slotNum].method_7960();
    }

    @Override
    public boolean shouldTrack(class_2338 pos, class_2680 state, class_2586 tileEntity, class_1937 level) {
        return ImmersiveCheckers.isAnvil(pos, state, tileEntity, level);
    }

    @Override
    public void trackObject(class_2338 pos, class_2680 state, class_2586 tileEntity, class_1937 level) {
        for (AnvilInfo info : this.getTrackedObjects()) {
            if (!info.getBlockPosition().equals((Object)pos)) continue;
            info.setTicksLeft(120);
            return;
        }
        this.infos.add(new AnvilInfo(pos, 120));
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveAnvil;
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, class_1657 player, int closest, class_1268 hand) {
        Network.INSTANCE.sendToServer((Object)new InteractPacket(info.getBlockPosition(), closest, hand));
    }

    protected boolean isAnvil(class_2680 state) {
        return state.method_26204() instanceof class_2199;
    }
}

