/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.client.immersive;

import java.util.Optional;
import net.blf02.immersivemc.client.immersive.AbstractImmersive;
import net.blf02.immersivemc.client.immersive.Immersives;
import net.blf02.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import net.blf02.immersivemc.client.immersive.info.BackpackInfo;
import net.blf02.immersivemc.client.model.BackpackCraftingModel;
import net.blf02.immersivemc.client.model.BackpackLowDetailModel;
import net.blf02.immersivemc.client.model.BackpackModel;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.packet.FetchPlayerStoragePacket;
import net.blf02.immersivemc.common.network.packet.InteractPacket;
import net.blf02.immersivemc.common.network.packet.InventorySwapPacket;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.common.util.Util;
import net.blf02.immersivemc.common.vr.VRPlugin;
import net.blf02.immersivemc.common.vr.VRPluginVerify;
import net.blf02.immersivemc.server.swap.Swap;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4608;

public class ImmersiveBackpack
extends AbstractImmersive<BackpackInfo> {
    public static final BackpackModel model = new BackpackModel(class_310.method_1551().method_31974().method_32072(BackpackModel.LAYER_LOCATION));
    public static final BackpackLowDetailModel modelLowDetail = new BackpackLowDetailModel(class_310.method_1551().method_31974().method_32072(BackpackLowDetailModel.LAYER_LOCATION));
    public static final BackpackCraftingModel craftingModel = new BackpackCraftingModel(class_310.method_1551().method_31974().method_32072(BackpackCraftingModel.LAYER_LOCATION));
    private final double spacing = 0.375;

    public ImmersiveBackpack() {
        super(1);
        this.forceDisableItemGuide = true;
    }

    @Override
    public boolean isVROnly() {
        return true;
    }

    @Override
    protected void doTick(BackpackInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724);
        this.calculatePositions(info, vrPlayer);
        Optional<Integer> hitboxIntersect = Util.getFirstIntersect(vrPlayer.getController0().position(), info.getAllHitboxes());
        info.slotHovered = hitboxIntersect.isPresent() ? hitboxIntersect.get() : -1;
    }

    public static void onHitboxInteract(class_1657 player, BackpackInfo info, int slot) {
        if (slot <= 26) {
            Network.INSTANCE.sendToServer((Object)new InventorySwapPacket(slot + 9));
            Swap.handleInventorySwap(player, slot + 9, class_1268.field_5808);
        } else {
            Network.INSTANCE.sendToServer((Object)new InteractPacket("backpack", slot, class_1268.field_5808));
            Network.INSTANCE.sendToServer((Object)new FetchPlayerStoragePacket("backpack"));
        }
    }

    protected boolean inRange(int num, int start, int end) {
        return start <= num && num <= end;
    }

    @Override
    public boolean shouldRender(BackpackInfo info, boolean isInVR) {
        return class_310.method_1551().field_1724 != null && VRPluginVerify.hasAPI && VRPlugin.API.playerInVR((class_1657)class_310.method_1551().field_1724) && VRPlugin.API.apiActive((class_1657)class_310.method_1551().field_1724) && info.readyToRender();
    }

    @Override
    protected void render(BackpackInfo tickInfo, class_4587 stack, boolean isInVR) {
        class_1799 item;
        int i;
        BackpackInfo renderInfo = this.getRenderInfo(tickInfo);
        for (i = 0; i <= 31; ++i) {
            class_238 hitbox = renderInfo.getHitbox(i);
            this.renderHitbox(stack, hitbox, renderInfo.getPosition(i));
        }
        for (i = 0; i <= 26; ++i) {
            item = class_310.method_1551().field_1724.method_31548().method_5438(i + 9);
            if (item.method_7960() || renderInfo.getPosition(i) == null) continue;
            float size = renderInfo.slotHovered == i ? 0.3f : 0.2f;
            this.renderItem(item, stack, renderInfo.getPosition(i), size, null, renderInfo.getHitbox(i), true);
        }
        for (i = 27; i <= 31; ++i) {
            class_1799 class_17992 = item = i == 31 ? tickInfo.craftingOutput : tickInfo.craftingInput[i - 27];
            if (item.method_7960() || renderInfo.getPosition(i) == null) continue;
            this.renderItem(item, stack, renderInfo.getPosition(i), 0.2f, null, renderInfo.getHitbox(i), true);
        }
        stack.method_22903();
        class_243 pos = renderInfo.renderPos;
        class_4184 cameraInfo = class_310.method_1551().field_1773.method_19418();
        stack.method_22904(-cameraInfo.method_19326().field_1352 + pos.field_1352, -cameraInfo.method_19326().field_1351 + pos.field_1351, -cameraInfo.method_19326().field_1350 + pos.field_1350);
        stack.method_22905(0.5f, 0.5f, 0.5f);
        stack.method_22904(0.0, 1.5, 0.0);
        stack.method_22907(class_1160.field_20704.method_23626(renderInfo.handYaw));
        stack.method_22907(class_1160.field_20702.method_23626(renderInfo.handPitch));
        stack.method_22907(class_1160.field_20707.method_23626((float)Math.PI));
        stack.method_22904(0.0, -1.5, 0.0);
        stack.method_22904(ActiveConfig.leftHandedBackpack ? -0.5 : 0.5, 0.0, 0.0);
        ImmersiveBackpack.getBackpackModel().method_2828(stack, class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23576((class_2960)BackpackModel.textureLocation)), 0xF000F0, class_4608.field_21444, renderInfo.rgb.method_4943(), renderInfo.rgb.method_4945(), renderInfo.rgb.method_4947(), 1.0f);
        stack.method_22904(ActiveConfig.leftHandedBackpack ? -0.75 : 0.75, 0.25, 0.0);
        craftingModel.method_2828(stack, class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23576((class_2960)BackpackCraftingModel.textureLocation)), 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.method_22909();
        for (int i2 = 0; i2 < renderInfo.getInputSlots().length; ++i2) {
            if (!this.slotShouldRenderHelpHitbox(tickInfo, i2)) continue;
            class_238 itemBox = renderInfo.getInputSlots()[i2];
            class_238 toShow = itemBox.method_989(0.0, itemBox.method_17940() / 2.0, 0.0);
            this.renderItemGuide(stack, toShow, 0.2f, this.slotHelpBoxIsGreen(renderInfo, i2));
        }
    }

    @Override
    protected boolean enabledInConfig() {
        return ActiveConfig.useBackpack;
    }

    @Override
    protected boolean slotShouldRenderHelpHitbox(BackpackInfo info, int slotNum) {
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        if (slotNum <= 26) {
            return class_310.method_1551().field_1724.method_31548().method_5438(slotNum + 9).method_7960();
        }
        int tableIndex = slotNum - 27;
        return info.craftingInput[tableIndex] == null || info.craftingInput[tableIndex].method_7960();
    }

    @Override
    public boolean shouldTrack(class_2338 pos, class_2680 state, class_2586 tileEntity, class_1937 level) {
        return true;
    }

    @Override
    public void trackObject(class_2338 pos, class_2680 state, class_2586 tileEntity, class_1937 level) {
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveBackpack;
    }

    @Override
    protected void initInfo(BackpackInfo info) {
        Network.INSTANCE.sendToServer((Object)new FetchPlayerStoragePacket("backpack"));
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, class_1657 player, int closest, class_1268 hand) {
    }

    public void processFromNetwork(ImmersiveStorage storage) {
        if (this.getSingleton().infos.size() > 0) {
            BackpackInfo info = (BackpackInfo)this.getSingleton().infos.get(0);
            for (int i = 0; i <= 3; ++i) {
                info.craftingInput[i] = storage.items[i];
            }
            info.craftingOutput = storage.items[4];
        }
    }

    public void doTrack() {
        if (this.infos.isEmpty()) {
            this.infos.add(new BackpackInfo());
        } else {
            this.infos.clear();
        }
    }

    public static class_3879 getBackpackModel() {
        if (ActiveConfig.useLowDetailBackpack) {
            return modelLowDetail;
        }
        return model;
    }

    private void calculatePositions(BackpackInfo info, IVRPlayer vrPlayer) {
        IVRData backpackController = vrPlayer.getController(1);
        info.handPos = backpackController.position();
        info.handPitch = (float)Math.toRadians(backpackController.getPitch());
        info.handYaw = (float)Math.toRadians(backpackController.getYaw());
        info.lookVec = backpackController.getLookAngle();
        info.backVec = info.lookVec.method_1029().method_18805(-1.0, -1.0, -1.0);
        info.renderPos = info.handPos.method_1031(0.0, -0.75, 0.0);
        info.renderPos = info.renderPos.method_1019(info.backVec.method_18805(0.16666666666666666, 0.16666666666666666, 0.16666666666666666));
        info.rgb = new class_1160((float)(ActiveConfig.backpackColor >> 16), (float)(ActiveConfig.backpackColor >> 8 & 0xFF), (float)(ActiveConfig.backpackColor & 0xFF));
        info.rgb.method_4942(0.003921569f);
        info.centerTopPos = info.handPos.method_1031(0.0, -0.05, 0.0);
        info.centerTopPos = info.centerTopPos.method_1019(info.backVec.method_18805(0.16666666666666666, 0.16666666666666666, 0.16666666666666666));
        class_243 rightVec = info.lookVec.method_18805(1.0E16, 0.0, 1.0E16).method_1029();
        rightVec = ActiveConfig.leftHandedBackpack ? new class_243(rightVec.field_1350, 0.0, -rightVec.field_1352).method_18805(0.25, 0.0, 0.25) : new class_243(-rightVec.field_1350, 0.0, rightVec.field_1352).method_18805(0.25, 0.0, 0.25);
        info.centerTopPos = info.centerTopPos.method_1019(rightVec);
        class_243 leftVec = rightVec.method_18805(-1.0, 0.0, -1.0);
        class_1160 downVecF = new class_1160(0.0f, -1.0f, 0.0f);
        downVecF.method_19262(class_1160.field_20702.method_23626(info.handPitch));
        downVecF.method_19262(class_1160.field_20704.method_23626(info.handYaw));
        info.downVec = new class_243((double)downVecF.method_4943(), (double)downVecF.method_4945(), (double)downVecF.method_4947()).method_1029();
        class_243 leftOffset = new class_243(leftVec.field_1352 * 0.375, leftVec.field_1351 * 0.375, leftVec.field_1350 * 0.375);
        class_243 rightOffset = new class_243(rightVec.field_1352 * 0.375, rightVec.field_1351 * 0.375, rightVec.field_1350 * 0.375);
        double tbSpacing = 0.09375;
        class_243 topOffset = info.lookVec.method_18805(tbSpacing, tbSpacing, tbSpacing);
        class_243 botOffset = info.backVec.method_18805(tbSpacing, tbSpacing, tbSpacing);
        class_243 pos = info.centerTopPos;
        class_243[] positions = new class_243[]{pos.method_1019(leftOffset).method_1019(topOffset), pos.method_1019(topOffset), pos.method_1019(rightOffset).method_1019(topOffset), pos.method_1019(leftOffset), pos, pos.method_1019(rightOffset), pos.method_1019(leftOffset).method_1019(botOffset), pos.method_1019(botOffset), pos.method_1019(rightOffset).method_1019(botOffset)};
        int start = 9 * info.topRow;
        int end = start + 8;
        int midStart = 9 * info.getMidRow();
        int midEnd = midStart + 8;
        class_243 downOne = info.downVec.method_18805(0.125, 0.125, 0.125);
        class_243 downTwo = downOne.method_18805(2.0, 2.0, 2.0);
        for (int i = 0; i <= 26; ++i) {
            class_243 posRaw = positions[i % 9];
            class_243 yDown = this.inRange(i, start, end) ? class_243.field_1353 : (this.inRange(i, midStart, midEnd) ? downOne : downTwo);
            class_243 slotPos = posRaw;
            slotPos = slotPos.method_1019(yDown);
            info.setPosition(i, slotPos);
            info.setHitbox(i, this.createHitbox(info.getPosition(i), 0.05f));
        }
        class_243 upVec = info.downVec.method_18805(-1.0, -1.0, -1.0);
        double upMult = 0.05;
        class_243 leftCraftingPos = info.centerTopPos.method_1019(rightVec.method_18805(1.25, 1.25, 1.25)).method_1019(upVec.method_18805(upMult, upMult, upMult));
        class_243 rightCraftingPos = info.centerTopPos.method_1019(rightVec.method_18805(1.75, 1.75, 1.75)).method_1019(upVec.method_18805(upMult, upMult, upMult));
        class_243 centerCraftingPos = info.centerTopPos.method_1019(rightVec.method_18805(1.5, 1.5, 1.5)).method_1019(upVec.method_18805(upMult, upMult, upMult));
        double craftingOffset = 0.625;
        class_243[] craftingPositions = new class_243[]{leftCraftingPos.method_1019(topOffset.method_18805(craftingOffset, craftingOffset, craftingOffset)), rightCraftingPos.method_1019(topOffset.method_18805(craftingOffset, craftingOffset, craftingOffset)), leftCraftingPos.method_1019(botOffset.method_18805(craftingOffset, craftingOffset, craftingOffset)), rightCraftingPos.method_1019(botOffset.method_18805(craftingOffset, craftingOffset, craftingOffset))};
        for (int i = 27; i <= 30; ++i) {
            info.setPosition(i, craftingPositions[i - 27]);
            info.setHitbox(i, this.createHitbox(info.getPosition(i), 0.05f));
        }
        info.setPosition(31, centerCraftingPos.method_1019(upVec.method_18805(0.125, 0.125, 0.125)));
        info.setHitbox(31, this.createHitbox(info.getPosition(31), 0.05f));
    }

    private BackpackInfo getRenderInfo(BackpackInfo tickInfo) {
        BackpackInfo renderInfo = new BackpackInfo();
        renderInfo.slotHovered = tickInfo.slotHovered;
        renderInfo.topRow = tickInfo.topRow;
        this.calculatePositions(renderInfo, VRPlugin.API.getRenderVRPlayer());
        renderInfo.setInputSlots();
        return renderInfo;
    }
}

