/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.client.immersive;

import java.util.Objects;
import net.blf02.immersivemc.client.immersive.AbstractBlockEntityImmersive;
import net.blf02.immersivemc.client.immersive.AbstractImmersive;
import net.blf02.immersivemc.client.immersive.Immersives;
import net.blf02.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import net.blf02.immersivemc.client.immersive.info.ChestInfo;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.packet.ChestShulkerOpenPacket;
import net.blf02.immersivemc.common.network.packet.FetchInventoryPacket;
import net.blf02.immersivemc.common.network.packet.SwapPacket;
import net.blf02.immersivemc.common.util.Util;
import net.blf02.immersivemc.common.vr.VRPlugin;
import net.blf02.immersivemc.common.vr.VRPluginVerify;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2336;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2611;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4739;

public class ImmersiveChest
extends AbstractBlockEntityImmersive<class_2586, ChestInfo> {
    private final double spacing = 0.1875;
    private final double threshold = 0.03;

    public ImmersiveChest() {
        super(4);
    }

    @Override
    protected void doTick(ChestInfo info, boolean isInVR) {
        class_2586 chest;
        if (!this.chestsValid(info)) {
            info.remove();
            return;
        }
        super.doTick(info, isInVR);
        if (info.ticksActive % 2 == 0) {
            if (info.other != null) {
                Network.INSTANCE.sendToServer((Object)new FetchInventoryPacket(info.other.method_11016()));
            } else if (info.getBlockEntity() instanceof class_2611) {
                Network.INSTANCE.sendToServer((Object)new FetchInventoryPacket(info.getBlockPosition()));
            }
        }
        class_2586[] chests = new class_2586[]{info.getBlockEntity(), info.other};
        for (int i = 0; i <= 1; ++i) {
            chest = chests[i];
            if (chest == null) continue;
            info.forward = (class_2350)chest.method_11010().method_11654((class_2769)class_2383.field_11177);
            class_243[] positions = this.get3x3HorizontalGrid(chest.method_11016(), 0.1875);
            float hitboxSize = 0.09166667f;
            int startTop = 9 * info.getRowNum() + 27 * i;
            int endTop = startTop + 9;
            for (int z = startTop; z < endTop; ++z) {
                class_243 posRaw = positions[z % 9];
                info.setPosition(z, posRaw.method_1031(0.0, -0.2, 0.0));
                info.setHitbox(z, this.createHitbox(posRaw.method_1031(0.0, -0.2, 0.0), hitboxSize));
            }
            int startMid = 9 * info.getNextRow(info.getRowNum()) + 27 * i;
            int endMid = startMid + 9;
            for (int z = startMid; z < endMid; ++z) {
                class_243 posRaw = positions[z % 9];
                info.setPosition(z, posRaw.method_1031(0.0, -0.325, 0.0));
                info.setHitbox(z, null);
            }
            int startBot = 9 * info.getNextRow(info.getNextRow(info.getRowNum())) + 27 * i;
            int endBot = startBot + 9;
            for (int z = startBot; z < endBot; ++z) {
                class_243 posRaw = positions[z % 9];
                info.setPosition(z, posRaw.method_1031(0.0, -0.45, 0.0));
                info.setHitbox(z, null);
            }
        }
        for (int chestNum = 0; chestNum <= 1; ++chestNum) {
            class_243 linePos;
            chest = chests[chestNum];
            if (chest == null) continue;
            class_243 forward = class_243.method_24954((class_2382)info.forward.method_10163());
            class_243 left = class_243.method_24954((class_2382)this.getLeftOfDirection(info.forward).method_10163());
            class_243 frontMid = this.getTopCenterOfBlock(chest.method_11016()).method_1019(forward.method_18805(0.5, 0.5, 0.5));
            if (info.isOpen) {
                linePos = frontMid.method_1019(forward.method_18805(-0.5, -0.5, -0.5));
                info.openClosePositions[chestNum] = linePos = linePos.method_1031(0.0, 0.5, 0.0);
                info.openCloseHitboxes[chestNum] = new class_238(linePos.method_1019(left.method_18805(-0.5, -0.5, -0.5)).method_1031(0.0, -0.25, 0.0).method_1019(forward.method_18805(-0.625, -0.625, -0.625)), linePos.method_1019(left.method_18805(0.5, 0.5, 0.5)).method_1031(0.0, 0.25, 0.0).method_1019(forward.method_18805(0.625, 0.625, 0.625)));
                continue;
            }
            info.openClosePositions[chestNum] = linePos = frontMid.method_1031(0.0, -0.375, 0.0);
            info.openCloseHitboxes[chestNum] = new class_238(linePos.method_1019(left.method_18805(-0.5, -0.5, -0.5)).method_1031(0.0, -0.25, 0.0).method_1019(forward.method_18805(-0.15, -0.15, -0.15)), linePos.method_1019(left.method_18805(0.5, 0.5, 0.5)).method_1031(0.0, 0.25, 0.0).method_1019(forward.method_18805(0.15, 0.15, 0.15)));
        }
        if (info.openCloseCooldown <= 0 && !ActiveConfig.rightClickChest) {
            if (VRPluginVerify.clientInVR && VRPlugin.API.apiActive((class_1657)class_310.method_1551().field_1724) && info.openCloseHitboxes != null) {
                boolean cond;
                class_243 current0 = VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724).getController0().position();
                class_243 current1 = VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724).getController1().position();
                double diff0 = current0.field_1351 - info.lastY0;
                double diff1 = current1.field_1351 - info.lastY1;
                if (!Util.getFirstIntersect(current0, info.openCloseHitboxes).isPresent()) {
                    diff0 = 0.0;
                }
                if (!Util.getFirstIntersect(current1, info.openCloseHitboxes).isPresent()) {
                    diff1 = 0.0;
                }
                if (info.isOpen) {
                    cond = diff0 <= -0.03 || diff1 <= -0.03;
                } else {
                    boolean bl = cond = diff0 >= 0.03 || diff1 >= 0.03;
                }
                if (cond) {
                    ImmersiveChest.openChest(info);
                    info.openCloseCooldown = 40;
                }
                info.lastY0 = current0.field_1351;
                info.lastY1 = current1.field_1351;
            }
        } else if (!ActiveConfig.rightClickChest) {
            --info.openCloseCooldown;
        }
    }

    @Override
    protected boolean slotShouldRenderHelpHitbox(ChestInfo info, int slotNum) {
        if (info.getBlockEntity() instanceof class_2611) {
            return info.items[slotNum] == null || info.items[slotNum].method_7960();
        }
        return super.slotShouldRenderHelpHitbox(info, slotNum);
    }

    @Override
    public boolean shouldTrack(class_2338 pos, class_2680 state, class_2586 tileEntity, class_1937 level) {
        return ImmersiveCheckers.isChest(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveChest;
    }

    @Override
    protected void render(ChestInfo info, class_4587 stack, boolean isInVR) {
        int i;
        float itemSize = 0.25f / (float)info.getItemTransitionCountdown();
        class_2350 forward = info.forward;
        if (info.isOpen) {
            float renderSize;
            boolean showCount;
            int endTop;
            int startTop;
            for (i = 0; i < 27; ++i) {
                startTop = 9 * info.getRowNum();
                endTop = startTop + 9;
                showCount = i >= startTop && i <= endTop;
                renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
                this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, forward, class_2350.field_11036, info.getHitbox(i), showCount, -1);
            }
            if (info.other != null) {
                for (i = 27; i < 54; ++i) {
                    startTop = 9 * info.getRowNum() + 27;
                    endTop = startTop + 9 + 27;
                    showCount = i >= startTop && i <= endTop;
                    renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
                    this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, forward, class_2350.field_11036, info.getHitbox(i), showCount, -1);
                }
            }
        }
        for (i = 0; i <= 1; ++i) {
            if (info.openCloseHitboxes[i] == null || info.openClosePositions[i] == null) continue;
            this.renderHitbox(stack, info.openCloseHitboxes[i], info.openClosePositions[i]);
        }
    }

    @Override
    public ChestInfo getNewInfo(class_2586 tileEnt) {
        if (tileEnt instanceof class_2595) {
            return new ChestInfo(tileEnt, Integer.MAX_VALUE, (class_2586)Util.getOtherChest((class_2595)tileEnt));
        }
        if (tileEnt instanceof class_2611) {
            return new ChestInfo(tileEnt, Integer.MAX_VALUE, null);
        }
        throw new IllegalArgumentException("ImmersiveChest can only track chests and ender chests!");
    }

    @Override
    public int getTickTime() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean shouldRender(ChestInfo info, boolean isInVR) {
        boolean dataReady = info.forward != null && info.readyToRender();
        return !info.failRender && dataReady && this.chestsValid(info);
    }

    public boolean chestsValid(ChestInfo info) {
        try {
            boolean mainChestExists;
            class_2248 mainChestBlock = info.getBlockEntity().method_10997().method_8320(info.getBlockPosition()).method_26204();
            boolean bl = mainChestExists = mainChestBlock instanceof class_4739 || mainChestBlock instanceof class_2336;
            boolean otherChestExists = info.other == null ? true : info.getBlockEntity().method_10997() != null && info.getBlockEntity().method_10997().method_8320(info.other.method_11016()).method_26204() instanceof class_4739;
            return mainChestExists && otherChestExists;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public boolean reallyShouldTrack(class_2586 tileEnt) {
        class_2595 other;
        if (tileEnt instanceof class_2595 && (other = Util.getOtherChest((class_2595)tileEnt)) != null) {
            for (AbstractImmersiveInfo abstractImmersiveInfo : this.getSingleton().getTrackedObjects()) {
                ChestInfo info = (ChestInfo)abstractImmersiveInfo;
                if (info.getBlockEntity() != other) continue;
                if (info.other == null) {
                    info.failRender = true;
                    info.other = tileEnt;
                    this.doTick(info, VRPluginVerify.clientInVR);
                    info.failRender = false;
                }
                return false;
            }
        }
        return super.reallyShouldTrack(tileEnt);
    }

    @Override
    protected boolean enabledInConfig() {
        return ActiveConfig.useChestImmersion;
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, class_1657 player, int closest, class_1268 hand) {
        if (!VRPluginVerify.clientInVR && !ActiveConfig.rightClickChest) {
            return;
        }
        if (!((ChestInfo)info).isOpen) {
            return;
        }
        Network.INSTANCE.sendToServer((Object)new SwapPacket(info.getBlockPosition(), closest, hand));
    }

    public static ChestInfo findImmersive(class_2586 chest) {
        Objects.requireNonNull(chest);
        for (ChestInfo info : Immersives.immersiveChest.getTrackedObjects()) {
            if (info.getBlockEntity() != chest && info.other != chest) continue;
            return info;
        }
        return null;
    }

    @Override
    public void onRemove(ChestInfo info) {
        super.onRemove(info);
        if (info.isOpen) {
            ImmersiveChest.openChest(info);
        }
    }

    @Override
    protected void initInfo(ChestInfo info) {
    }

    public static void openChest(ChestInfo info) {
        info.isOpen = !info.isOpen;
        Network.INSTANCE.sendToServer((Object)new ChestShulkerOpenPacket(info.getBlockPosition(), info.isOpen));
        if (!info.isOpen) {
            info.remove();
        }
    }

    @Override
    public boolean hitboxesAvailable(AbstractImmersiveInfo info) {
        return ((ChestInfo)info).isOpen;
    }
}

