/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.client.immersive;

import java.util.Objects;
import net.blf02.immersivemc.client.immersive.AbstractImmersive;
import net.blf02.immersivemc.client.immersive.AbstractWorldStorageImmersive;
import net.blf02.immersivemc.client.immersive.Immersives;
import net.blf02.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import net.blf02.immersivemc.client.immersive.info.AbstractWorldStorageInfo;
import net.blf02.immersivemc.client.immersive.info.CraftingInfo;
import net.blf02.immersivemc.client.immersive.info.InfoTriggerHitboxes;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.packet.GetRecipePacket;
import net.blf02.immersivemc.common.network.packet.InteractPacket;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public class ImmersiveCrafting
extends AbstractWorldStorageImmersive<CraftingInfo> {
    private final double spacing = 0.1875;

    public ImmersiveCrafting() {
        super(2);
    }

    @Override
    protected void initInfo(CraftingInfo info) {
        this.setHitboxes(info);
    }

    protected void setHitboxes(CraftingInfo info) {
        class_2350 forward;
        Objects.requireNonNull(class_310.method_1551().field_1724);
        Objects.requireNonNull(class_310.method_1551().field_1687);
        info.isTinkersTable = class_310.method_1551().field_1687.method_8321(info.getBlockPosition()) != null;
        try {
            forward = info.isTinkersTable ? (class_2350)class_310.method_1551().field_1687.method_8320(info.getBlockPosition()).method_11654((class_2769)class_2741.field_12481) : this.getForwardFromPlayer((class_1657)class_310.method_1551().field_1724);
        }
        catch (IllegalArgumentException e) {
            forward = this.getForwardFromPlayer((class_1657)class_310.method_1551().field_1724);
        }
        class_243[] positions = this.get3x3HorizontalGrid(info.getBlockPosition(), 0.1875, forward);
        float hitboxSize = 0.0625f;
        for (int i = 0; i < 9; ++i) {
            info.setPosition(i, positions[i]);
            info.setHitbox(i, this.createHitbox(positions[i], hitboxSize));
        }
        info.outputPosition = info.getPosition(4).method_1031(0.0, 0.5, 0.0);
        info.outputHitbox = this.createHitbox(info.outputPosition, hitboxSize * 3.0f);
        info.lastDir = forward;
    }

    @Override
    protected void doTick(CraftingInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        Objects.requireNonNull(class_310.method_1551().field_1724);
        class_2350 forward = this.getForwardFromPlayer((class_1657)class_310.method_1551().field_1724);
        if (info.lastDir != forward) {
            this.setHitboxes(info);
        }
        if (info.isTinkersTable && info.ticksActive % 4 == 0) {
            Network.INSTANCE.sendToServer((Object)new GetRecipePacket(info.getBlockPosition()));
        }
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, class_1657 player, int closest, class_1268 hand) {
        Network.INSTANCE.sendToServer((Object)new InteractPacket(info.getBlockPosition(), closest, hand));
    }

    @Override
    public void handleTriggerHitboxRightClick(InfoTriggerHitboxes info, class_1657 player, int hitboxNum) {
        AbstractImmersiveInfo aInfo = (AbstractImmersiveInfo)((Object)info);
        Network.INSTANCE.sendToServer((Object)new InteractPacket(aInfo.getBlockPosition(), 9, class_1268.field_5808));
        ((CraftingInfo)info).setTicksLeft(120);
    }

    @Override
    protected void render(CraftingInfo info, class_4587 stack, boolean isInVR) {
        float itemSize = 0.1875f / (float)info.getItemTransitionCountdown();
        class_2350 forward = this.getForwardFromPlayer((class_1657)class_310.method_1551().field_1724);
        for (int i = 0; i < 9; ++i) {
            float renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
            this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, forward, class_2350.field_11036, info.getHitbox(i), true, -1);
        }
        int degreesRotation = (int)((double)info.ticksActive % 100.0 * 3.6);
        this.renderItem(info.outputItem, stack, info.outputPosition, itemSize * 3.0f, forward, null, info.outputHitbox, true, ActiveConfig.spinCraftingOutput ? degreesRotation : -1);
    }

    @Override
    protected boolean enabledInConfig() {
        return ActiveConfig.useCraftingImmersion;
    }

    @Override
    public boolean shouldTrack(class_2338 pos, class_2680 state, class_2586 tileEntity, class_1937 level) {
        return ImmersiveCheckers.isCraftingTable(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveCrafting;
    }

    @Override
    public void processStorageFromNetwork(AbstractWorldStorageInfo info, ImmersiveStorage storageIn) {
        for (int i = 0; i <= 8; ++i) {
            info.items[i] = storageIn.items[i];
        }
        CraftingInfo cInfo = (CraftingInfo)info;
        cInfo.outputItem = storageIn.items[9];
    }

    @Override
    public CraftingInfo getNewInfo(class_2338 pos) {
        return new CraftingInfo(pos, this.getTickTime());
    }

    @Override
    public int getTickTime() {
        return 120;
    }

    @Override
    public boolean shouldRender(CraftingInfo info, boolean isInVR) {
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        class_638 level = class_310.method_1551().field_1687;
        return level != null && level.method_8320(info.getBlockPosition().method_10084()).method_26215() && info.readyToRender();
    }

    @Override
    public int getCooldownVR() {
        return 7;
    }
}

