/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.client.immersive;

import java.util.Objects;
import java.util.Optional;
import net.blf02.immersivemc.client.immersive.AbstractImmersive;
import net.blf02.immersivemc.client.immersive.Immersives;
import net.blf02.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import net.blf02.immersivemc.client.immersive.info.RepeaterInfo;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.packet.SetRepeaterPacket;
import net.blf02.immersivemc.common.util.Util;
import net.blf02.immersivemc.common.vr.VRPlugin;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2462;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public class ImmersiveRepeater
extends AbstractImmersive<RepeaterInfo> {
    public ImmersiveRepeater() {
        super(2);
    }

    @Override
    public boolean isVROnly() {
        return true;
    }

    @Override
    protected void initInfo(RepeaterInfo info) {
        Objects.requireNonNull(class_310.method_1551().field_1687);
        class_2680 state = class_310.method_1551().field_1687.method_8320(info.getBlockPosition());
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2383.field_11177);
        class_2350 forwardDir = facing.method_10153();
        class_243 forward = class_243.method_24954((class_2382)forwardDir.method_10163());
        class_243 centerPos = this.getTopCenterOfBlock(info.getBlockPosition()).method_1031(0.0, -0.675, 0.0);
        info.setPosition(0, centerPos.method_1019(forward.method_18805(0.0625, 0.0, 0.0625)));
        info.setPosition(1, centerPos.method_1019(forward.method_18805(-0.0625, 0.0, -0.0625)));
        info.setPosition(2, centerPos.method_1019(forward.method_18805(-0.1875, 0.0, -0.1875)));
        info.setPosition(3, centerPos.method_1019(forward.method_18805(-0.3125, 0.0, -0.3125)));
        for (int i = 0; i <= 3; ++i) {
            info.setHitbox(i, this.createHitbox(info.getPosition(i), 0.071428575f).method_1009(0.0, 0.2, 0.0));
        }
    }

    @Override
    protected void doTick(RepeaterInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        if (!(class_310.method_1551().field_1687.method_8320(info.getBlockPosition()).method_26204() instanceof class_2462)) {
            info.remove();
            return;
        }
        if (isInVR) {
            class_2680 state = class_310.method_1551().field_1687.method_8320(info.getBlockPosition());
            for (int c = 0; c <= 1; ++c) {
                class_243 pos = VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724).getController(c).position();
                Optional<Integer> hit = Util.getClosestIntersect(pos, info.getAllHitboxes(), info.getAllPositions());
                int repeaterValue = (Integer)state.method_11654((class_2769)class_2462.field_11451);
                if (hit.isPresent()) {
                    int delayHit = hit.get() + 1;
                    if (delayHit == repeaterValue) {
                        info.grabbedCurrent[c] = true;
                        continue;
                    }
                    if (!info.grabbedCurrent[c]) continue;
                    Util.setRepeater((class_1937)class_310.method_1551().field_1687, info.getBlockPosition(), delayHit);
                    Network.INSTANCE.sendToServer((Object)new SetRepeaterPacket(info.getBlockPosition(), delayHit));
                    continue;
                }
                info.grabbedCurrent[c] = false;
            }
        }
    }

    @Override
    public boolean shouldRender(RepeaterInfo info, boolean isInVR) {
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        class_638 level = class_310.method_1551().field_1687;
        return level != null && level.method_8320(info.getBlockPosition().method_10084()).method_26215() && info.readyToRender();
    }

    @Override
    protected void render(RepeaterInfo info, class_4587 stack, boolean isInVR) {
        for (int i = 0; i <= 3; ++i) {
            this.renderHitbox(stack, info.getHitbox(i), info.getPosition(i));
        }
    }

    @Override
    protected boolean enabledInConfig() {
        return ActiveConfig.useRepeaterImmersion;
    }

    @Override
    protected boolean slotShouldRenderHelpHitbox(RepeaterInfo info, int slotNum) {
        return false;
    }

    @Override
    public boolean shouldTrack(class_2338 pos, class_2680 state, class_2586 tileEntity, class_1937 level) {
        return ImmersiveCheckers.isRepeater(pos, state, tileEntity, level);
    }

    @Override
    public void trackObject(class_2338 pos, class_2680 state, class_2586 tileEntity, class_1937 level) {
        for (RepeaterInfo info : this.getTrackedObjects()) {
            if (!info.getBlockPosition().equals((Object)pos)) continue;
            info.setTicksLeft(80);
            return;
        }
        this.infos.add(new RepeaterInfo(pos));
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveRepeater;
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, class_1657 player, int closest, class_1268 hand) {
    }
}

