/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.client.immersive;

import net.blf02.immersivemc.client.immersive.AbstractBlockEntityImmersive;
import net.blf02.immersivemc.client.immersive.AbstractImmersive;
import net.blf02.immersivemc.client.immersive.Immersives;
import net.blf02.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import net.blf02.immersivemc.client.immersive.info.ShulkerInfo;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.packet.ChestShulkerOpenPacket;
import net.blf02.immersivemc.common.network.packet.SwapPacket;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class ImmersiveShulker
extends AbstractBlockEntityImmersive<class_2627, ShulkerInfo> {
    public ImmersiveShulker() {
        super(4);
    }

    @Override
    public ShulkerInfo getNewInfo(class_2586 tileEnt) {
        return new ShulkerInfo((class_2627)tileEnt, 300);
    }

    @Override
    public int getTickTime() {
        return 300;
    }

    @Override
    public boolean shouldRender(ShulkerInfo info, boolean isInVR) {
        return info.readyToRender() && info.isOpen;
    }

    @Override
    protected void render(ShulkerInfo info, class_4587 stack, boolean isInVR) {
        float itemSize = 0.2f / (float)info.getItemTransitionCountdown();
        for (int i = 0; i < 27; ++i) {
            float renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
            this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, this.getForwardFromPlayer((class_1657)class_310.method_1551().field_1724), null, info.getHitbox(i), true, -1);
        }
    }

    @Override
    protected boolean enabledInConfig() {
        return ActiveConfig.useShulkerImmersion;
    }

    @Override
    public boolean shouldTrack(class_2338 pos, class_2680 state, class_2586 tileEntity, class_1937 level) {
        return ImmersiveCheckers.isShulkerBox(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveShulker;
    }

    @Override
    protected void initInfo(ShulkerInfo info) {
        this.setHitboxes(info);
    }

    public void setHitboxes(ShulkerInfo info) {
        int i;
        class_243[] positions = this.get3x3VerticalGrid(info.getBlockPosition(), 0.15);
        for (i = 0; i < 27; ++i) {
            info.setHitbox(i, null);
            info.setPosition(i, null);
        }
        for (i = 0; i < 9; ++i) {
            positions[i] = positions[i].method_1031(0.0, 0.25, 0.0);
            info.setHitbox(i + info.getRowNum() * 9, this.createHitbox(positions[i], 0.075f));
            info.setPosition(i + info.getRowNum() * 9, positions[i]);
        }
        info.lastDir = this.getForwardFromPlayer((class_1657)class_310.method_1551().field_1724);
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, class_1657 player, int closest, class_1268 hand) {
        if (((ShulkerInfo)info).isOpen) {
            Network.INSTANCE.sendToServer((Object)new SwapPacket(info.getBlockPosition(), closest, hand));
        }
    }

    @Override
    protected void doTick(ShulkerInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        if (info.lastDir != this.getForwardFromPlayer((class_1657)class_310.method_1551().field_1724)) {
            this.setHitboxes(info);
        }
    }

    public static void openShulkerBox(ShulkerInfo info) {
        info.isOpen = !info.isOpen;
        Network.INSTANCE.sendToServer((Object)new ChestShulkerOpenPacket(info.getBlockPosition(), info.isOpen));
        if (!info.isOpen) {
            info.remove();
        }
    }

    @Override
    public boolean hitboxesAvailable(AbstractImmersiveInfo info) {
        return ((ShulkerInfo)info).isOpen;
    }
}

