/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.common.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.network.NetworkUtil;
import net.blf02.immersivemc.common.util.Util;
import net.blf02.immersivemc.server.ChestToOpenCount;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2611;
import net.minecraft.class_2627;
import net.minecraft.class_3222;
import net.minecraft.class_4838;

public class ChestShulkerOpenPacket {
    public class_2338 pos;
    public boolean isOpen;

    public ChestShulkerOpenPacket(class_2338 pos, boolean isOpenPacket) {
        this.pos = pos;
        this.isOpen = isOpenPacket;
    }

    public static void encode(ChestShulkerOpenPacket packet, class_2540 buffer) {
        buffer.method_10807(packet.pos).writeBoolean(packet.isOpen);
    }

    public static ChestShulkerOpenPacket decode(class_2540 buffer) {
        return new ChestShulkerOpenPacket(buffer.method_10811(), buffer.readBoolean());
    }

    public static void handle(ChestShulkerOpenPacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            class_3222 player;
            class_3222 class_32222 = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof class_3222 ? (class_3222)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player != null && NetworkUtil.safeToRun(message.pos, player)) {
                class_2586 tileEnt = player.field_6002.method_8321(message.pos);
                if (tileEnt instanceof class_2595) {
                    if (!ActiveConfig.useChestImmersion) {
                        return;
                    }
                    class_2595 chest = (class_2595)tileEnt;
                    class_2595 other = Util.getOtherChest(chest);
                    if (message.isOpen) {
                        chest.method_5435((class_1657)player);
                        ChestShulkerOpenPacket.changeChestCount(chest.method_11016(), 1);
                        if (other != null) {
                            other.method_5435((class_1657)player);
                            ChestShulkerOpenPacket.changeChestCount(other.method_11016(), 1);
                        }
                        class_4838.method_24733((class_1657)player, (boolean)true);
                    } else {
                        chest.method_5432((class_1657)player);
                        ChestShulkerOpenPacket.changeChestCount(chest.method_11016(), -1);
                        if (other != null) {
                            other.method_5432((class_1657)player);
                            ChestShulkerOpenPacket.changeChestCount(other.method_11016(), -1);
                        }
                    }
                } else if (tileEnt instanceof class_2611) {
                    if (!ActiveConfig.useChestImmersion) {
                        return;
                    }
                    class_2611 chest = (class_2611)tileEnt;
                    if (message.isOpen) {
                        chest.method_11219((class_1657)player);
                        ChestShulkerOpenPacket.changeChestCount(chest.method_11016(), 1);
                        class_4838.method_24733((class_1657)player, (boolean)true);
                    } else {
                        chest.method_11220((class_1657)player);
                        ChestShulkerOpenPacket.changeChestCount(chest.method_11016(), -1);
                    }
                } else if (tileEnt instanceof class_2627) {
                    class_2627 shulkerBox = (class_2627)tileEnt;
                    if (!ActiveConfig.useShulkerImmersion) {
                        return;
                    }
                    if (message.isOpen) {
                        shulkerBox.method_5435((class_1657)player);
                    } else {
                        shulkerBox.method_5432((class_1657)player);
                    }
                }
            }
        });
    }

    protected static void changeChestCount(class_2338 pos, int amount) {
        Integer currentVal = ChestToOpenCount.chestImmersiveOpenCount.get(pos);
        int newVal = currentVal == null || currentVal == 0 ? amount : amount + currentVal;
        if (newVal <= 0) {
            ChestToOpenCount.chestImmersiveOpenCount.remove(pos);
        } else {
            ChestToOpenCount.chestImmersiveOpenCount.put(pos, newVal);
        }
    }
}

