/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.common.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.config.ImmersiveMCConfig;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.server.PlayerConfigs;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;

public class ConfigSyncPacket {
    protected class_2540 buffer;
    protected boolean kickMe = false;
    protected boolean isToServerConfigPacket = false;

    public ConfigSyncPacket() {
    }

    protected ConfigSyncPacket(boolean kickMe) {
        this.kickMe = true;
    }

    public static ConfigSyncPacket getKickMePacket() {
        return new ConfigSyncPacket(true);
    }

    public static ConfigSyncPacket getToServerConfigPacket() {
        ConfigSyncPacket packet = new ConfigSyncPacket();
        packet.isToServerConfigPacket = true;
        return packet;
    }

    public ConfigSyncPacket(class_2540 configBuffer) {
        this.buffer = configBuffer;
    }

    public static void encode(ConfigSyncPacket packet, class_2540 buffer) {
        buffer.writeBoolean(packet.kickMe);
        if (!packet.kickMe) {
            if (packet.isToServerConfigPacket) {
                ActiveConfig.encodeServerOnlyConfig(buffer);
            } else {
                ImmersiveMCConfig.encode(buffer);
            }
        }
    }

    public static ConfigSyncPacket decode(class_2540 buffer) {
        if (buffer.readBoolean()) {
            return ConfigSyncPacket.getKickMePacket();
        }
        buffer.retain();
        return new ConfigSyncPacket(buffer);
    }

    public static void handle(ConfigSyncPacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            class_3222 player;
            class_3222 class_32222 = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof class_3222 ? (class_3222)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player == null) {
                ActiveConfig.loadConfigFromPacket(message.buffer);
                Network.INSTANCE.sendToServer((Object)ConfigSyncPacket.getToServerConfigPacket());
            } else if (message.kickMe) {
                ((class_3222)((NetworkManager.PacketContext)ctx.get()).getPlayer()).field_13987.method_14367((class_2561)new class_2585("The server is using a different version of ImmersiveMC than you!"));
            } else {
                PlayerConfigs.registerConfig(((NetworkManager.PacketContext)ctx.get()).getPlayer(), message.buffer);
            }
        });
    }
}

