/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.common.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.NetworkClientHandlers;
import net.blf02.immersivemc.common.network.NetworkUtil;
import net.blf02.immersivemc.common.network.packet.UpdateStoragePacket;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.server.storage.GetStorage;
import net.blf02.immersivemc.server.storage.ImmersiveMCLevelStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2611;
import net.minecraft.class_3222;

public class FetchInventoryPacket {
    public final class_1799[] items;
    public final class_2338 pos;

    public FetchInventoryPacket(class_2338 pos) {
        this(null, pos);
    }

    public FetchInventoryPacket(class_1799[] items, class_2338 pos) {
        this.items = items;
        this.pos = pos;
    }

    public boolean isRequest() {
        return this.items != null;
    }

    public static void encode(FetchInventoryPacket packet, class_2540 buffer) {
        buffer.method_10807(packet.pos);
        buffer.writeBoolean(packet.isRequest());
        if (packet.isRequest()) {
            buffer.writeInt(packet.items.length);
            for (class_1799 s : packet.items) {
                buffer.method_10793(s);
            }
        }
    }

    public static FetchInventoryPacket decode(class_2540 buffer) {
        class_2338 pos = buffer.method_10811();
        class_1799[] stacks = null;
        if (buffer.readBoolean()) {
            int size = buffer.readInt();
            stacks = new class_1799[size];
            for (int i = 0; i < size; ++i) {
                stacks[i] = buffer.method_10819();
            }
        }
        return new FetchInventoryPacket(stacks, pos);
    }

    public static void handle(FetchInventoryPacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            class_3222 player;
            class_3222 class_32222 = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof class_3222 ? (class_3222)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player != null) {
                FetchInventoryPacket.handleServerToClient(player, message.pos);
            } else {
                NetworkClientHandlers.handleReceiveInvData(message.items, message.pos);
            }
        });
    }

    public static void handleServerToClient(class_3222 player, class_2338 pos) {
        if (NetworkUtil.safeToRun(pos, player)) {
            class_2586 tileEnt = player.field_6002.method_8321(pos);
            if (ImmersiveMCLevelStorage.usesWorldStorage(pos, player.field_6002.method_8320(pos), tileEnt, player.field_6002)) {
                ImmersiveStorage storage = GetStorage.getStorage((class_1657)player, pos);
                if (storage != null) {
                    Network.INSTANCE.sendToPlayer(player, (Object)new UpdateStoragePacket(pos, storage, storage.getType()));
                }
            } else if (tileEnt != null) {
                class_1263 inv;
                if (tileEnt instanceof class_1263) {
                    inv = (class_1263)tileEnt;
                } else if (tileEnt instanceof class_2611) {
                    inv = player.method_7274();
                } else {
                    return;
                }
                class_1799[] stacks = new class_1799[inv.method_5439()];
                for (int i = 0; i < inv.method_5439(); ++i) {
                    stacks[i] = inv.method_5438(i);
                }
                Network.INSTANCE.sendToPlayer(player, (Object)new FetchInventoryPacket(stacks, pos));
            }
        }
    }
}

