/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.common.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.blf02.immersivemc.client.immersive.Immersives;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.server.storage.GetStorage;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class FetchPlayerStoragePacket {
    public final String storageKey;
    public final ImmersiveStorage storage;

    public FetchPlayerStoragePacket(String storageKey) {
        this.storageKey = storageKey;
        this.storage = null;
    }

    public FetchPlayerStoragePacket(ImmersiveStorage storage, String storageKey) {
        this.storage = storage;
        this.storageKey = storageKey;
    }

    public boolean isRequest() {
        return this.storage == null;
    }

    public static void encode(FetchPlayerStoragePacket packet, class_2540 buffer) {
        buffer.writeBoolean(packet.isRequest());
        if (packet.isRequest()) {
            buffer.method_10814(packet.storageKey);
        } else {
            buffer.method_10794(packet.storage.save(new class_2487()));
            buffer.method_10814(packet.storageKey);
        }
    }

    public static FetchPlayerStoragePacket decode(class_2540 buffer) {
        boolean isRequest = buffer.readBoolean();
        if (isRequest) {
            return new FetchPlayerStoragePacket(buffer.method_19772());
        }
        class_2487 storageTag = buffer.method_10798();
        String storageType = buffer.method_19772();
        return new FetchPlayerStoragePacket(GetStorage.assembleStorage(storageTag, "basic_item_store", null), storageType);
    }

    public static void handle(FetchPlayerStoragePacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            class_3222 player;
            class_3222 class_32222 = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof class_3222 ? (class_3222)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player == null) {
                FetchPlayerStoragePacket.handleClient(message);
            } else {
                ImmersiveStorage storage = GetStorage.getPlayerStorage((class_1657)player, message.storageKey);
                Network.INSTANCE.sendToPlayer(player, (Object)new FetchPlayerStoragePacket(storage, message.storageKey));
            }
        });
    }

    public static void handleClient(FetchPlayerStoragePacket message) {
        if (message.storageKey.equals("backpack")) {
            Immersives.immersiveBackpack.processFromNetwork(message.storage);
        }
    }
}

