/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.common.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.blf02.immersivemc.client.immersive.Immersives;
import net.blf02.immersivemc.client.immersive.info.EnchantingInfo;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.NetworkUtil;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.server.storage.GetStorage;
import net.minecraft.class_1657;
import net.minecraft.class_1718;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2605;
import net.minecraft.class_3222;
import net.minecraft.class_3914;

public class GetEnchantmentsPacket {
    public final class_2338 pos;
    public final int weakXPLevels;
    public final int weakEnchHint;
    public final int weakLevelHint;
    public final int midXPLevels;
    public final int midEnchHint;
    public final int midLevelHint;
    public final int strongXPLevels;
    public final int strongEnchHint;
    public final int strongLevelHint;

    public GetEnchantmentsPacket(class_2338 pos) {
        this.pos = pos;
        this.weakXPLevels = -999;
        this.weakEnchHint = -1;
        this.weakLevelHint = -1;
        this.midXPLevels = -1;
        this.midEnchHint = -1;
        this.midLevelHint = -1;
        this.strongXPLevels = -1;
        this.strongEnchHint = -1;
        this.strongLevelHint = -1;
    }

    public GetEnchantmentsPacket(int weakXPLevels, int weakEnchHint, int weakLevelHint, int midXPLevels, int midEnchHint, int midLevelHint, int strongXPLevels, int strongEnchHint, int strongLevelHint, class_2338 pos) {
        this.weakXPLevels = weakXPLevels;
        this.weakEnchHint = weakEnchHint;
        this.weakLevelHint = weakLevelHint;
        this.midXPLevels = midXPLevels;
        this.midEnchHint = midEnchHint;
        this.midLevelHint = midLevelHint;
        this.strongXPLevels = strongXPLevels;
        this.strongEnchHint = strongEnchHint;
        this.strongLevelHint = strongLevelHint;
        this.pos = pos;
    }

    public static void encode(GetEnchantmentsPacket packet, class_2540 buffer) {
        buffer.writeBoolean(packet.weakXPLevels == -999);
        if (packet.weakXPLevels == -999) {
            buffer.method_10807(packet.pos);
        } else {
            buffer.writeInt(packet.weakXPLevels);
            buffer.writeInt(packet.weakEnchHint);
            buffer.writeInt(packet.weakLevelHint);
            buffer.writeInt(packet.midXPLevels);
            buffer.writeInt(packet.midEnchHint);
            buffer.writeInt(packet.midLevelHint);
            buffer.writeInt(packet.strongXPLevels);
            buffer.writeInt(packet.strongEnchHint);
            buffer.writeInt(packet.strongLevelHint);
            buffer.method_10807(packet.pos);
        }
    }

    public static GetEnchantmentsPacket decode(class_2540 buffer) {
        if (buffer.readBoolean()) {
            return new GetEnchantmentsPacket(buffer.method_10811());
        }
        return new GetEnchantmentsPacket(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.method_10811());
    }

    public static void handle(GetEnchantmentsPacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            class_3222 player;
            class_3222 class_32222 = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof class_3222 ? (class_3222)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player == null) {
                GetEnchantmentsPacket.handleClient(message);
            } else if (NetworkUtil.safeToRun(message.pos, player)) {
                class_2586 tileEnt;
                ImmersiveStorage enchantStorage = GetStorage.getEnchantingStorage((class_1657)player, message.pos);
                if (enchantStorage.items[0] != null && !enchantStorage.items[0].method_7960() && (tileEnt = player.field_6002.method_8321(message.pos)) instanceof class_2605) {
                    class_1718 container = new class_1718(-1, player.method_31548(), class_3914.method_17392((class_1937)player.field_6002, (class_2338)message.pos));
                    container.method_7619(1, 0, new class_1799((class_1935)class_1802.field_8759, 64));
                    container.method_7619(0, 0, enchantStorage.items[0]);
                    int[] xpLevels = container.field_7808;
                    int[] descs = container.field_7812;
                    int[] enchLevels = container.field_7810;
                    Network.INSTANCE.sendToPlayer(player, (Object)new GetEnchantmentsPacket(xpLevels[0], descs[0], enchLevels[0], xpLevels[1], descs[1], enchLevels[1], xpLevels[2], descs[2], enchLevels[2], message.pos));
                }
            }
        });
    }

    protected static void handleClient(GetEnchantmentsPacket message) {
        for (EnchantingInfo info : Immersives.immersiveETable.getTrackedObjects()) {
            if (!info.getBlockPosition().equals((Object)message.pos)) continue;
            class_1887 ench = GetEnchantmentsPacket.getEnch(message.weakEnchHint);
            if (ench != null) {
                info.weakInfo.levelsNeeded = message.weakXPLevels;
                info.weakInfo.textPreview = GetEnchantmentsPacket.getDesc(ench, message.weakLevelHint);
            } else {
                info.weakInfo.textPreview = null;
            }
            ench = GetEnchantmentsPacket.getEnch(message.midEnchHint);
            if (ench != null) {
                info.midInfo.levelsNeeded = message.midXPLevels;
                info.midInfo.textPreview = GetEnchantmentsPacket.getDesc(ench, message.midLevelHint);
            } else {
                info.midInfo.textPreview = null;
            }
            ench = GetEnchantmentsPacket.getEnch(message.strongEnchHint);
            if (ench != null) {
                info.strongInfo.levelsNeeded = message.strongXPLevels;
                info.strongInfo.textPreview = GetEnchantmentsPacket.getDesc(ench, message.strongLevelHint);
                continue;
            }
            info.strongInfo.textPreview = null;
        }
    }

    protected static class_1887 getEnch(int id) {
        return class_1887.method_8191((int)id);
    }

    protected static class_2585 getDesc(class_1887 ench, int enchLevel) {
        return new class_2585(ench.method_8179(enchLevel).getString() + "...?");
    }
}

