/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.common.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.config.ServerPlayerConfig;
import net.blf02.immersivemc.common.util.Util;
import net.blf02.immersivemc.server.PlayerConfigs;
import net.blf02.immersivemc.server.tracker.RangedGrabTrackerServer;
import net.blf02.immersivemc.server.tracker.ServerTrackerInit;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class GrabItemPacket {
    public final int entityId;

    public GrabItemPacket(class_1542 item) {
        this.entityId = item.method_5628();
    }

    public GrabItemPacket(int entityId) {
        this.entityId = entityId;
    }

    public static void encode(GrabItemPacket packet, class_2540 buffer) {
        buffer.writeInt(packet.entityId);
    }

    public static GrabItemPacket decode(class_2540 buffer) {
        return new GrabItemPacket(buffer.readInt());
    }

    public static void handle(GrabItemPacket packet, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            class_3222 player;
            if (!ActiveConfig.useRangedGrab) {
                return;
            }
            class_3222 class_32222 = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof class_3222 ? (class_3222)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player != null) {
                class_1297 ent = player.field_6002.method_8469(packet.entityId);
                ServerPlayerConfig config = PlayerConfigs.getConfig((class_1657)player);
                int range = config.rangedGrabRange == -1 ? 5 : (config.rangedGrabRange + 1) * 2;
                if (ent instanceof class_1542 && player.method_5858(ent) <= (double)(range * range) && Util.canPickUpItem((class_1542)ent, (class_1657)player)) {
                    class_1542 item = (class_1542)ent;
                    ServerTrackerInit.rangedGrabTracker.infos.add(new RangedGrabTrackerServer.RangedGrabInfo(item, player));
                }
            }
        });
    }
}

