/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.common.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.blf02.immersivemc.client.SafeClientUtil;
import net.blf02.immersivemc.common.config.PlacementMode;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.network.NetworkUtil;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.server.storage.GetStorage;
import net.blf02.immersivemc.server.swap.Swap;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class InteractPacket {
    public final class_2338 pos;
    public final String storageKey;
    public final int slot;
    public final class_1268 hand;
    public PlacementMode placementMode = SafeClientUtil.getPlacementMode();

    public InteractPacket(class_2338 pos, int slot, class_1268 hand) {
        this.pos = pos;
        this.slot = slot;
        this.hand = hand;
        this.storageKey = null;
    }

    public InteractPacket(String storageKey, int slot, class_1268 hand) {
        this.storageKey = storageKey;
        this.slot = slot;
        this.hand = hand;
        this.pos = null;
        if (storageKey.equals("backpack")) {
            this.placementMode = SafeClientUtil.getPlacementMode(true);
        }
    }

    protected InteractPacket setPlacementMode(PlacementMode mode) {
        this.placementMode = mode;
        return this;
    }

    public boolean isPlayerStorageInteract() {
        return this.storageKey != null;
    }

    public static void encode(InteractPacket packet, class_2540 buffer) {
        buffer.method_10817((Enum)packet.placementMode);
        buffer.writeBoolean(packet.isPlayerStorageInteract());
        if (packet.isPlayerStorageInteract()) {
            buffer.method_10814(packet.storageKey);
        } else {
            buffer.method_10807(packet.pos);
        }
        buffer.writeInt(packet.slot).writeInt(packet.hand == class_1268.field_5808 ? 0 : 1);
    }

    public static InteractPacket decode(class_2540 buffer) {
        PlacementMode mode = (PlacementMode)buffer.method_10818(PlacementMode.class);
        if (buffer.readBoolean()) {
            return new InteractPacket(buffer.method_19772(), buffer.readInt(), buffer.readInt() == 0 ? class_1268.field_5808 : class_1268.field_5810).setPlacementMode(mode);
        }
        return new InteractPacket(buffer.method_10811(), buffer.readInt(), buffer.readInt() == 0 ? class_1268.field_5808 : class_1268.field_5810).setPlacementMode(mode);
    }

    public static void handle(InteractPacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            class_3222 player;
            class_3222 class_32222 = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof class_3222 ? (class_3222)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (message.isPlayerStorageInteract()) {
                if (message.storageKey.equals("backpack")) {
                    ImmersiveStorage storage = GetStorage.getPlayerStorage((class_1657)player, "backpack");
                    Swap.handleBackpackCraftingSwap(message.slot - 27, message.hand, storage, player, message.placementMode);
                }
            } else if (NetworkUtil.safeToRun(message.pos, player)) {
                class_2586 tileEnt;
                class_2680 state = player.field_6002.method_8320(message.pos);
                if (ImmersiveCheckers.isCraftingTable(message.pos, state, tileEnt = player.field_6002.method_8321(message.pos), player.field_6002)) {
                    Swap.handleCraftingSwap(player, message.slot, message.hand, message.pos, message.placementMode);
                } else if (ImmersiveCheckers.isAnvil(message.pos, state, tileEnt, player.field_6002)) {
                    Swap.anvilSwap(message.slot, message.hand, message.pos, player, message.placementMode);
                } else if (ImmersiveCheckers.isEnchantingTable(message.pos, state, tileEnt, player.field_6002)) {
                    Swap.enchantingTableSwap(player, message.slot, message.hand, message.pos);
                }
            }
        });
    }
}

