/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.common.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.blf02.immersivemc.client.SafeClientUtil;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.config.PlacementMode;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.network.NetworkUtil;
import net.blf02.immersivemc.server.swap.Swap;
import net.minecraft.class_1268;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2589;
import net.minecraft.class_2595;
import net.minecraft.class_2611;
import net.minecraft.class_2619;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class SwapPacket {
    public final class_2338 block;
    public final int slot;
    public final class_1268 hand;
    public PlacementMode placementMode = SafeClientUtil.getPlacementMode();

    public SwapPacket(class_2338 block, int slot, class_1268 hand) {
        this.block = block;
        this.slot = slot;
        this.hand = hand;
    }

    public static void encode(SwapPacket packet, class_2540 buffer) {
        buffer.method_10817((Enum)packet.placementMode);
        buffer.method_10807(packet.block);
        buffer.writeInt(packet.slot);
        buffer.writeInt(packet.hand == class_1268.field_5808 ? 0 : 1);
    }

    public static SwapPacket decode(class_2540 buffer) {
        PlacementMode mode = (PlacementMode)buffer.method_10818(PlacementMode.class);
        SwapPacket packet = new SwapPacket(buffer.method_10811(), buffer.readInt(), buffer.readInt() == 0 ? class_1268.field_5808 : class_1268.field_5810);
        packet.placementMode = mode;
        return packet;
    }

    public static void handle(SwapPacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            class_3222 player;
            class_3222 class_32222 = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof class_3222 ? (class_3222)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (NetworkUtil.safeToRun(message.block, player)) {
                class_2586 tileEnt = player.field_6002.method_8321(message.block);
                class_2680 state = player.field_6002.method_8320(message.block);
                if (ImmersiveCheckers.isFurnace(message.block, state, tileEnt, player.field_6002) && ActiveConfig.useFurnaceImmersion) {
                    Swap.handleFurnaceSwap((class_1278)tileEnt, (class_1657)player, message.hand, message.slot, message.placementMode);
                } else if (ImmersiveCheckers.isBrewingStand(message.block, state, tileEnt, player.field_6002) && ActiveConfig.useBrewingImmersion) {
                    class_2589 stand = (class_2589)tileEnt;
                    Swap.handleBrewingSwap(stand, (class_1657)player, message.hand, message.slot, message.placementMode);
                } else if (ImmersiveCheckers.isJukebox(message.block, state, tileEnt, player.field_6002) && ActiveConfig.useJukeboxImmersion) {
                    Swap.handleJukebox((class_2619)tileEnt, player, message.hand);
                } else if (ImmersiveCheckers.isChest(message.block, state, tileEnt, player.field_6002) && ActiveConfig.useChestImmersion) {
                    if (tileEnt instanceof class_2595) {
                        class_2595 cbe = (class_2595)tileEnt;
                        Swap.handleChest(cbe, (class_1657)player, message.hand, message.slot);
                    } else if (tileEnt instanceof class_2611) {
                        Swap.handleEnderChest((class_1657)player, message.hand, message.slot);
                    }
                } else if (ImmersiveCheckers.isShulkerBox(message.block, state, tileEnt, player.field_6002)) {
                    Swap.shulkerBoxSwap(player, message.slot, message.hand, message.block);
                }
            }
        });
    }
}

