/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.common.util;

import java.util.Optional;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2462;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class Util {
    public static void addStackToInventory(class_1657 player, class_1799 item) {
        if (!item.method_7960()) {
            player.method_31548().method_7394(item);
        }
    }

    public static boolean canPickUpItem(class_1542 item, class_1657 player) {
        return (!item.method_6977() || player.method_31549().field_7477) && Math.abs(item.method_18798().field_1352) <= 0.01 && Math.abs(item.method_18798().field_1350) <= 0.01;
    }

    public static Optional<Integer> rayTraceClosest(class_243 rayStart, class_243 rayEnd, class_238 ... targets) {
        double dist = Double.MAX_VALUE;
        Integer winner = null;
        int i = 0;
        for (class_238 target : targets) {
            if (target != null) {
                double distTemp;
                if (target.method_1006(rayStart)) {
                    return Optional.of(i);
                }
                Optional closestHitOpt = target.method_992(rayStart, rayEnd);
                double d = distTemp = closestHitOpt.isPresent() ? ((class_243)closestHitOpt.get()).method_1022(rayStart) : -1.0;
                if (closestHitOpt.isPresent() && distTemp < dist) {
                    winner = i;
                    dist = distTemp;
                }
            }
            ++i;
        }
        return Optional.ofNullable(winner);
    }

    public static Optional<Integer> getFirstIntersect(class_243 pos, class_238 ... targets) {
        int i = 0;
        for (class_238 target : targets) {
            if (target != null && target.method_1006(pos)) {
                return Optional.of(i);
            }
            ++i;
        }
        return Optional.empty();
    }

    public static Optional<Integer> getClosestIntersect(class_243 pos, class_238[] targets, class_243[] positions) {
        if (targets.length != positions.length) {
            throw new IllegalArgumentException("Targets and positions must be same length!");
        }
        int res = -1;
        double distanceToBeat = Double.MAX_VALUE;
        for (int i = 0; i < targets.length; ++i) {
            double newDist;
            if (targets[i] == null || !targets[i].method_1006(pos) || !((newDist = pos.method_1025(positions[i])) < distanceToBeat)) continue;
            distanceToBeat = newDist;
            res = i;
        }
        return res == -1 ? Optional.empty() : Optional.of(res);
    }

    public static class_2595 getOtherChest(class_2595 chest) {
        return Util.getOtherChest(chest, true);
    }

    protected static class_2595 getOtherChest(class_2595 chest, boolean checkOther) {
        class_2350 otherDir = class_2281.method_9758((class_2680)chest.method_11010());
        class_2338 otherPos = chest.method_11016().method_10093(otherDir);
        if (chest.method_10997() != null && chest.method_10997().method_8321(otherPos) instanceof class_2595) {
            class_2595 other = (class_2595)chest.method_10997().method_8321(otherPos);
            if (checkOther && other != null) {
                return Util.getOtherChest(other, false) == chest ? other : null;
            }
            return other;
        }
        return null;
    }

    public static boolean stacksEqualBesidesCount(class_1799 a, class_1799 b) {
        int oldCountA = a.method_7947();
        int oldCountB = b.method_7947();
        a.method_7939(1);
        b.method_7939(1);
        boolean res = class_1799.method_7973((class_1799)a, (class_1799)b);
        a.method_7939(oldCountA);
        b.method_7939(oldCountB);
        return res;
    }

    public static ItemStackMergeResult mergeStacks(class_1799 mergeIntoIn, class_1799 mergeFromIn, boolean useCopy) {
        if (!Util.stacksEqualBesidesCount(mergeIntoIn, mergeFromIn) || mergeIntoIn.method_7914() <= 1) {
            return new ItemStackMergeResult(mergeIntoIn, mergeFromIn);
        }
        class_1799 into = useCopy ? mergeIntoIn.method_7972() : mergeIntoIn;
        class_1799 from = useCopy ? mergeFromIn.method_7972() : mergeFromIn;
        int totalCount = into.method_7947() + from.method_7947();
        int fromAmount = 0;
        if (totalCount > into.method_7914()) {
            fromAmount = totalCount - into.method_7914();
            totalCount = into.method_7914();
        }
        into.method_7939(totalCount);
        from.method_7939(fromAmount);
        return new ItemStackMergeResult(into, fromAmount == 0 ? class_1799.field_8037 : from);
    }

    public static void setRepeater(class_1937 level, class_2338 pos, int newDelay) {
        class_2680 state = level.method_8320(pos);
        if (state.method_26204() instanceof class_2462) {
            state = (class_2680)state.method_11657((class_2769)class_2462.field_11451, (Comparable)Integer.valueOf(newDelay));
            level.method_8652(pos, state, 3);
        }
    }

    public static class_243 getPlayerVelocity(class_243 lastTickPos, class_243 currentTickPos) {
        return new class_243(currentTickPos.field_1352 - lastTickPos.field_1352, currentTickPos.field_1351 - lastTickPos.field_1351, currentTickPos.field_1350 - lastTickPos.field_1350);
    }

    public static double moveTowardsZero(double num, double subtract) {
        if ((subtract = Math.abs(subtract)) >= Math.abs(num)) {
            return 0.0;
        }
        if (num < 0.0) {
            return num + subtract;
        }
        return num - subtract;
    }

    public static class ItemStackMergeResult {
        public final class_1799 mergedInto;
        public final class_1799 mergedFrom;

        public ItemStackMergeResult(class_1799 mergedInto, class_1799 mergedFrom) {
            this.mergedInto = mergedInto;
            this.mergedFrom = mergedFrom;
        }

        public String toString() {
            return "Merged Into: " + this.mergedInto + "\nMerged From: " + this.mergedFrom;
        }
    }
}

