/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server;

import dev.architectury.event.EventResult;
import dev.architectury.utils.value.IntValue;
import java.util.List;
import net.blf02.immersivemc.ImmersiveMC;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.immersive.CheckerFunction;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.packet.ConfigSyncPacket;
import net.blf02.immersivemc.common.network.packet.ImmersiveBreakPacket;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.common.tracker.AbstractTracker;
import net.blf02.immersivemc.common.vr.VRPluginVerify;
import net.blf02.immersivemc.server.ChestToOpenCount;
import net.blf02.immersivemc.server.storage.GetStorage;
import net.blf02.immersivemc.server.storage.ImmersiveMCLevelStorage;
import net.blf02.immersivemc.server.tracker.ServerTrackerInit;
import net.blf02.immersivemc.server.tracker.ServerVRSubscriber;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ServerSubscriber {
    /*
     * WARNING - void declaration
     */
    public static EventResult blockBreak(class_1937 level, class_2338 pos, class_2680 state, class_3222 player, @Nullable IntValue xp) {
        Object storage;
        if (level.field_9236) {
            return EventResult.pass();
        }
        class_3218 world = (class_3218)level;
        boolean sendBreakPacket = false;
        if (ImmersiveMCLevelStorage.usesWorldStorage(pos, state, world.method_8321(pos), (class_1937)world) && (storage = ImmersiveMCLevelStorage.getLevelStorage(world).remove(pos)) != null) {
            void var8_9;
            boolean bl = false;
            while (var8_9 <= GetStorage.getLastInputIndex(pos, state, world.method_8321(pos), (class_1937)world)) {
                class_243 vecPos = class_243.method_24953((class_2382)pos);
                class_1799 stack = ((ImmersiveStorage)storage).items[var8_9];
                if (stack != null && !stack.method_7960()) {
                    class_1542 itemEnt = new class_1542(level, vecPos.field_1352, vecPos.field_1351, vecPos.field_1350, stack);
                    level.method_8649((class_1297)itemEnt);
                }
                ++var8_9;
            }
        }
        for (CheckerFunction checkerFunction : ImmersiveCheckers.CHECKERS) {
            if (!((Boolean)checkerFunction.apply(pos, level.method_8320(pos), level.method_8321(pos), level)).booleanValue()) continue;
            sendBreakPacket = true;
            break;
        }
        if (sendBreakPacket) {
            class_238 nearbyBox = class_238.method_30048((class_243)class_243.method_24953((class_2382)pos), (double)20.0, (double)20.0, (double)20.0);
            List list = level.method_18467(class_3222.class, nearbyBox);
            Network.INSTANCE.sendToPlayers((Iterable)list, (Object)new ImmersiveBreakPacket(pos));
            ChestToOpenCount.chestImmersiveOpenCount.remove(pos);
        }
        return EventResult.pass();
    }

    public static void onServerTick(MinecraftServer server) {
        for (AbstractTracker tracker : ServerTrackerInit.globalTrackers) {
            tracker.doTick(null);
        }
        if (ActiveConfig.clientForceServerReloadForLAN) {
            ImmersiveMC.LOGGER.debug("Force-reloading config due to singleplayer config change!");
            ActiveConfig.loadConfigFromFile(true);
            ImmersiveMC.LOGGER.debug("Sending new config to all players.");
            Network.INSTANCE.sendToPlayers((Iterable)server.method_3760().method_14571(), (Object)new ConfigSyncPacket());
            ActiveConfig.clientForceServerReloadForLAN = false;
        }
    }

    public static void onPlayerTick(class_1657 player) {
        if (player.field_6002.field_9236) {
            return;
        }
        for (AbstractTracker tracker : ServerTrackerInit.playerTrackers) {
            tracker.doTick(player);
        }
        if (VRPluginVerify.hasAPI) {
            ServerVRSubscriber.vrPlayerTick(player);
        }
    }

    public static void onPlayerJoin(class_1657 player) {
        if (!player.field_6002.field_9236 && player instanceof class_3222) {
            ActiveConfig.loadConfigFromFile(true);
            Network.INSTANCE.sendToPlayer((class_3222)player, (Object)new ConfigSyncPacket());
        }
    }
}

