/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server.storage;

import java.util.List;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.storage.AnvilStorage;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.server.storage.ImmersiveMCLevelStorage;
import net.blf02.immersivemc.server.storage.ImmersiveMCPlayerStorages;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class GetStorage {
    public static ImmersiveStorage assembleStorage(class_2487 nbt, String storageType, class_18 wStorage) {
        ImmersiveStorage storage = null;
        if (storageType.equals("basic_item_store")) {
            storage = new ImmersiveStorage(wStorage);
            storage.load(nbt);
        } else if (storageType.equals("anvil_store")) {
            storage = new AnvilStorage(wStorage);
            storage.load(nbt);
        }
        if (storage == null) {
            throw new IllegalArgumentException("Storage type " + storageType + " does not exist!");
        }
        return storage;
    }

    public static int getLastInputIndex(class_2338 pos, class_2680 state, class_2586 tileEntity, class_1937 level) {
        if (ImmersiveCheckers.isCraftingTable(pos, state, tileEntity, level)) {
            return 8;
        }
        if (ImmersiveCheckers.isAnvil(pos, state, tileEntity, level)) {
            return 1;
        }
        if (ImmersiveCheckers.isEnchantingTable(pos, state, tileEntity, level)) {
            return 0;
        }
        return -1;
    }

    public static ImmersiveStorage getPlayerStorage(class_1657 player, String playerStorageKey) {
        List<ImmersiveStorage> storages = ImmersiveMCPlayerStorages.getStorages(player);
        for (ImmersiveStorage storage : storages) {
            if (!storage.identifier.equals("backpack")) continue;
            return storage;
        }
        if (playerStorageKey.equals("backpack")) {
            ImmersiveStorage storage = new ImmersiveStorage(ImmersiveMCPlayerStorages.getPlayerStorage(player)).initIfNotAlready(5);
            storage.identifier = "backpack";
            ImmersiveMCPlayerStorages.getStorages(player).add(storage);
            ImmersiveMCPlayerStorages.getPlayerStorage(player).method_80();
            return storage;
        }
        throw new IllegalArgumentException("Invalid player storage type!");
    }

    public static ImmersiveStorage getStorage(class_1657 player, class_2338 pos) {
        class_2586 tileEnt;
        class_2680 state = player.field_6002.method_8320(pos);
        if (ImmersiveCheckers.isCraftingTable(pos, state, tileEnt = player.field_6002.method_8321(pos), player.field_6002)) {
            return GetStorage.getCraftingStorage(player, pos);
        }
        if (ImmersiveCheckers.isAnvil(pos, state, tileEnt, player.field_6002)) {
            return GetStorage.getAnvilStorage(player, pos);
        }
        if (ImmersiveCheckers.isEnchantingTable(pos, state, tileEnt, player.field_6002)) {
            return GetStorage.getEnchantingStorage(player, pos);
        }
        return null;
    }

    public static ImmersiveStorage getEnchantingStorage(class_1657 player, class_2338 pos) {
        return ImmersiveMCLevelStorage.getLevelStorage(player).getOrCreate(pos).initIfNotAlready(1);
    }

    public static AnvilStorage getAnvilStorage(class_1657 player, class_2338 pos) {
        AnvilStorage storage;
        ImmersiveMCLevelStorage wStorage = ImmersiveMCLevelStorage.getLevelStorage(player);
        ImmersiveStorage storageOld = wStorage.get(pos);
        if (!(storageOld instanceof AnvilStorage)) {
            storage = new AnvilStorage(wStorage);
            storage.initIfNotAlready(3);
            ImmersiveMCLevelStorage.getLevelStorage(player).add(pos, storage);
        } else {
            storage = (AnvilStorage)storageOld;
        }
        return storage;
    }

    public static ImmersiveStorage getCraftingStorage(class_1657 player, class_2338 pos) {
        return ImmersiveMCLevelStorage.getLevelStorage(player).getOrCreate(pos).initIfNotAlready(10);
    }
}

