/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server.storage;

import java.util.HashMap;
import java.util.Map;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.server.storage.GetStorage;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ImmersiveMCLevelStorage
extends class_18 {
    protected Map<class_2338, ImmersiveStorage> itemInfo = new HashMap<class_2338, ImmersiveStorage>();

    private static ImmersiveMCLevelStorage create() {
        return new ImmersiveMCLevelStorage();
    }

    public static boolean usesWorldStorage(class_2338 pos, class_2680 state, class_2586 tileEntity, class_1937 level) {
        return ImmersiveCheckers.isCraftingTable(pos, state, tileEntity, level) || ImmersiveCheckers.isAnvil(pos, state, tileEntity, level) || ImmersiveCheckers.isEnchantingTable(pos, state, tileEntity, level);
    }

    public static ImmersiveMCLevelStorage getLevelStorage(class_3218 world) {
        return (ImmersiveMCLevelStorage)world.method_17983().method_17924(ImmersiveMCLevelStorage::load, ImmersiveMCLevelStorage::create, "immersivemc_data");
    }

    public static ImmersiveMCLevelStorage getLevelStorage(class_1657 player) {
        if (player instanceof class_3222) {
            return ImmersiveMCLevelStorage.getLevelStorage((class_3218)player.field_6002);
        }
        throw new IllegalArgumentException("Can only get storage server side!");
    }

    public ImmersiveStorage getOrCreate(class_2338 pos) {
        ImmersiveStorage storage = this.get(pos);
        if (storage == null) {
            storage = new ImmersiveStorage(this);
            this.add(pos, storage);
        }
        return storage;
    }

    public ImmersiveStorage remove(class_2338 pos) {
        ImmersiveStorage storage = this.itemInfo.remove(pos);
        this.method_80();
        return storage;
    }

    public void add(class_2338 pos, ImmersiveStorage storage) {
        this.itemInfo.put(pos, storage);
        this.method_80();
    }

    public ImmersiveStorage get(class_2338 pos) {
        return this.itemInfo.get(pos);
    }

    public static ImmersiveMCLevelStorage load(class_2487 nbt) {
        ImmersiveMCLevelStorage levelStorage = new ImmersiveMCLevelStorage();
        Map<class_2338, ImmersiveStorage> itemInfo = levelStorage.itemInfo;
        itemInfo.clear();
        int numOfStorages = nbt.method_10550("numOfStorages");
        class_2487 storages = nbt.method_10562("storages");
        for (int i = 0; i < numOfStorages; ++i) {
            class_2487 storageInfo = storages.method_10562(String.valueOf(i));
            class_2338 pos = new class_2338(storageInfo.method_10550("posX"), storageInfo.method_10550("posY"), storageInfo.method_10550("posZ"));
            String storageType = storageInfo.method_10558("dataType");
            ImmersiveStorage storage = GetStorage.assembleStorage(storageInfo.method_10562("data"), storageType, levelStorage);
            itemInfo.put(pos, storage);
        }
        return levelStorage;
    }

    public class_2487 method_75(class_2487 nbt) {
        nbt.method_10569("numOfStorages", this.itemInfo.size());
        class_2487 storages = new class_2487();
        int i = 0;
        for (Map.Entry<class_2338, ImmersiveStorage> entry : this.itemInfo.entrySet()) {
            class_2487 storageInfo = new class_2487();
            storageInfo.method_10569("posX", entry.getKey().method_10263());
            storageInfo.method_10569("posY", entry.getKey().method_10264());
            storageInfo.method_10569("posZ", entry.getKey().method_10260());
            storageInfo.method_10566("data", (class_2520)entry.getValue().save(new class_2487()));
            storageInfo.method_10582("dataType", entry.getValue().getType());
            storages.method_10566(String.valueOf(i), (class_2520)storageInfo);
            ++i;
        }
        nbt.method_10566("storages", (class_2520)storages);
        return nbt;
    }
}

