/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.server.storage.GetStorage;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class ImmersiveMCPlayerStorages
extends class_18 {
    protected Map<UUID, List<ImmersiveStorage>> playerStorages = new HashMap<UUID, List<ImmersiveStorage>>();

    private static ImmersiveMCPlayerStorages create() {
        return new ImmersiveMCPlayerStorages();
    }

    public static List<ImmersiveStorage> getStorages(class_1657 player) {
        List<ImmersiveStorage> immersiveStorages = ImmersiveMCPlayerStorages.getPlayerStorage((class_1657)player).playerStorages.get(player.method_5667());
        if (immersiveStorages == null) {
            immersiveStorages = new ArrayList<ImmersiveStorage>();
            ImmersiveMCPlayerStorages.getPlayerStorage((class_1657)player).playerStorages.put(player.method_5667(), immersiveStorages);
        }
        return immersiveStorages;
    }

    public static ImmersiveMCPlayerStorages getPlayerStorage(class_1657 player) {
        if (!player.field_6002.field_9236) {
            class_3222 sPlayer = (class_3222)player;
            return (ImmersiveMCPlayerStorages)sPlayer.method_5682().method_30002().method_17983().method_17924(ImmersiveMCPlayerStorages::load, ImmersiveMCPlayerStorages::create, "immersivemc_player_data");
        }
        throw new IllegalArgumentException("Can only access storage on server-side!");
    }

    public static ImmersiveMCPlayerStorages load(class_2487 nbt) {
        ImmersiveMCPlayerStorages playerStorage = new ImmersiveMCPlayerStorages();
        Set keys = nbt.method_10541();
        for (String uuidStr : keys) {
            UUID uuid = UUID.fromString(uuidStr);
            class_2487 playerTag = nbt.method_10562(uuidStr);
            class_2487 storagesTag = playerTag.method_10562("storages");
            int numStorages = storagesTag.method_10550("numStorages");
            ArrayList<ImmersiveStorage> storages = new ArrayList<ImmersiveStorage>();
            for (int i = 0; i < numStorages; ++i) {
                class_2487 storageInfo = storagesTag.method_10562(String.valueOf(i));
                String storageType = storageInfo.method_10558("dataType");
                ImmersiveStorage storage = GetStorage.assembleStorage(storageInfo.method_10562("data"), storageType, playerStorage);
                storages.add(storage);
            }
            playerStorage.playerStorages.put(uuid, storages);
        }
        return playerStorage;
    }

    public class_2487 method_75(class_2487 nbt) {
        for (Map.Entry<UUID, List<ImmersiveStorage>> entry : this.playerStorages.entrySet()) {
            class_2487 playerTag = new class_2487();
            class_2487 storagesTag = new class_2487();
            int numStorages = entry.getValue().size();
            storagesTag.method_10569("numStorages", numStorages);
            for (int i = 0; i < numStorages; ++i) {
                class_2487 storageInfo = new class_2487();
                storageInfo.method_10566("data", (class_2520)entry.getValue().get(i).save(new class_2487()));
                storageInfo.method_10582("dataType", entry.getValue().get(i).getType());
                storagesTag.method_10566(String.valueOf(i), (class_2520)storageInfo);
            }
            playerTag.method_10566("storages", (class_2520)storagesTag);
            nbt.method_10566(entry.getKey().toString(), (class_2520)playerTag);
        }
        return nbt;
    }
}

