/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server.swap;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.blf02.immersivemc.common.config.PlacementMode;
import net.blf02.immersivemc.common.storage.AnvilStorage;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.common.storage.workarounds.NullContainer;
import net.blf02.immersivemc.common.util.Util;
import net.blf02.immersivemc.mixin.AnvilMenuMixin;
import net.blf02.immersivemc.server.storage.GetStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1706;
import net.minecraft.class_1715;
import net.minecraft.class_1718;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1813;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2387;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2589;
import net.minecraft.class_2595;
import net.minecraft.class_2619;
import net.minecraft.class_2627;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3717;
import net.minecraft.class_3914;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_4862;

public class Swap {
    public static void shulkerBoxSwap(class_3222 player, int slot, class_1268 hand, class_2338 pos) {
        class_2586 class_25862 = player.field_6002.method_8321(pos);
        if (class_25862 instanceof class_2627) {
            class_2627 shulkerBox = (class_2627)class_25862;
            class_1799 shulkerItem = shulkerBox.method_5438(slot).method_7972();
            class_1799 playerItem = player.method_5998(hand);
            if (playerItem.method_7960() || shulkerItem.method_7960() || !Util.stacksEqualBesidesCount(shulkerItem, playerItem)) {
                player.method_6122(hand, shulkerItem);
                shulkerBox.method_5447(slot, playerItem);
            } else {
                Util.ItemStackMergeResult result = Util.mergeStacks(shulkerItem, playerItem, false);
                player.method_6122(hand, result.mergedFrom);
                shulkerBox.method_5447(slot, result.mergedInto);
            }
        }
    }

    public static void enchantingTableSwap(class_3222 player, int slot, class_1268 hand, class_2338 pos) {
        if (player == null) {
            return;
        }
        ImmersiveStorage enchStorage = GetStorage.getEnchantingStorage((class_1657)player, pos);
        if (slot == 0) {
            class_1799 toEnchant = player.method_5998(hand).method_7972();
            class_1799 toPlayer = enchStorage.items[0].method_7972();
            if (!toEnchant.method_7960() && !toEnchant.method_7923()) {
                return;
            }
            player.method_6122(hand, toPlayer);
            enchStorage.items[0] = toEnchant;
        } else if (player.method_5998(hand).method_7960()) {
            Swap.doEnchanting(slot, pos, player, hand);
        }
        enchStorage.wStorage.method_80();
    }

    public static void doEnchanting(int slot, class_2338 pos, class_3222 player, class_1268 hand) {
        if (!player.method_5998(hand).method_7960()) {
            return;
        }
        if (slot < 1 || slot > 3) {
            return;
        }
        ImmersiveStorage storage = GetStorage.getEnchantingStorage((class_1657)player, pos);
        class_1799 toEnchantItem = storage.items[0].method_7972();
        if (toEnchantItem.method_7960()) {
            return;
        }
        int lapisInInventory = 0;
        for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
            if (player.method_31548().method_5438(i).method_7909() != class_1802.field_8759) continue;
            lapisInInventory += player.method_31548().method_5438(i).method_7947();
        }
        if (lapisInInventory < slot && !player.method_31549().field_7477) {
            return;
        }
        class_1718 container = new class_1718(-1, player.method_31548(), class_3914.method_17392((class_1937)player.field_6002, (class_2338)pos));
        container.method_7619(1, 0, new class_1799((class_1935)class_1802.field_8759, 64));
        container.method_7619(0, 0, toEnchantItem);
        if (container.method_7604((class_1657)player, slot - 1)) {
            int lapisToTake = slot;
            for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                if (player.method_31548().method_5438(i).method_7909() == class_1802.field_8759) {
                    class_1799 stack = player.method_31548().method_5438(i);
                    while (!stack.method_7960() && lapisToTake > 0) {
                        stack.method_7934(1);
                        --lapisToTake;
                    }
                }
                if (lapisToTake == 0) break;
            }
            player.method_6122(hand, container.method_7611(0).method_7677());
            storage.items[0] = class_1799.field_8037;
        }
    }

    public static void handleBackpackCraftingSwap(int slot, class_1268 hand, ImmersiveStorage storage, class_3222 player, PlacementMode mode) {
        if (slot < 4) {
            class_1799 playerItem = player.method_5998(hand);
            class_1799 tableItem = storage.items[slot];
            SwapResult result = Swap.getSwap(playerItem, tableItem, mode);
            storage.items[slot] = result.toOther;
            Swap.givePlayerItemSwap(result.toHand, playerItem, (class_1657)player, hand);
            Swap.placeLeftovers((class_1657)player, result.leftovers);
            class_3955 recipe = Swap.getRecipe(player, storage.items);
            storage.items[4] = recipe != null ? recipe.method_8110() : class_1799.field_8037;
        } else {
            Swap.handleDoCraft(player, storage.items, null);
        }
        storage.wStorage.method_80();
    }

    public static void anvilSwap(int slot, class_1268 hand, class_2338 pos, class_3222 player, PlacementMode mode) {
        class_1937 level = player.field_6002;
        boolean isReallyAnvil = level.method_8320(pos).method_26204() instanceof class_2199;
        AnvilStorage storage = GetStorage.getAnvilStorage((class_1657)player, pos);
        if (slot != 2) {
            class_1799 playerItem = player.method_5998(hand);
            class_1799 anvilItem = storage.items[slot];
            SwapResult result = Swap.getSwap(playerItem, anvilItem, mode);
            storage.items[slot] = result.toOther;
            Swap.givePlayerItemSwap(result.toHand, playerItem, (class_1657)player, hand);
            Swap.placeLeftovers((class_1657)player, result.leftovers);
            storage.items[2] = class_1799.field_8037;
            if (isReallyAnvil) {
                storage.xpLevels = 0;
            }
            if (!storage.items[0].method_7960() && !storage.items[1].method_7960()) {
                Pair<class_1799, Integer> output = Swap.getAnvilOutput(storage.items[0], storage.items[1], isReallyAnvil, player);
                storage.items[2] = (class_1799)output.getFirst();
                storage.xpLevels = (Integer)output.getSecond();
            }
        } else if (!storage.items[2].method_7960()) {
            if (!player.method_5998(hand).method_7960()) {
                return;
            }
            Swap.handleAnvilCraft(storage, pos, player, hand);
        }
        storage.wStorage.method_80();
    }

    public static void handleAnvilCraft(AnvilStorage storage, class_2338 pos, class_3222 player, class_1268 hand) {
        if (!player.method_5998(hand).method_7960()) {
            return;
        }
        class_1799[] items = storage.items;
        class_1799 left = items[0];
        class_1799 mid = items[1];
        boolean isReallyAnvil = player.field_6002.method_8320(pos).method_26204() instanceof class_2199;
        boolean isSmithingTable = player.field_6002.method_8320(pos).method_26204() instanceof class_3717;
        if (!isReallyAnvil && !isSmithingTable) {
            return;
        }
        Pair<class_1799, Integer> resAndCost = Swap.getAnvilOutput(left, mid, isReallyAnvil, player);
        if ((player.field_7520 >= (Integer)resAndCost.getSecond() || player.method_31549().field_7477) && !((class_1799)resAndCost.getFirst()).method_7960()) {
            Object container = isReallyAnvil ? new class_1706(-1, player.method_31548(), class_3914.method_17392((class_1937)player.field_6002, (class_2338)pos)) : new class_4862(-1, player.method_31548(), class_3914.method_17392((class_1937)player.field_6002, (class_2338)pos));
            container.method_7611(2).method_7667((class_1657)player, (class_1799)resAndCost.getFirst());
            if (!player.method_31549().field_7477) {
                player.method_7316(-((Integer)resAndCost.getSecond()).intValue());
            }
            left.method_7934(1);
            mid.method_7934(1);
            items[2] = class_1799.field_8037;
            storage.xpLevels = 0;
            player.method_6122(hand, (class_1799)resAndCost.getFirst());
        }
    }

    public static void handleCraftingSwap(class_3222 player, int slot, class_1268 hand, class_2338 tablePos, PlacementMode mode) {
        ImmersiveStorage storage = GetStorage.getCraftingStorage((class_1657)player, tablePos);
        class_2586 class_25862 = player.field_6002.method_8321(tablePos);
        if (class_25862 instanceof class_1263) {
            class_1263 table = (class_1263)class_25862;
            playerItem = player.method_5998(hand).method_7972();
            class_1799 craftingItem = table.method_5438(slot).method_7972();
            if (slot < 9) {
                SwapResult result = Swap.getSwap(playerItem, craftingItem, mode);
                Swap.givePlayerItemSwap(result.toHand, playerItem, (class_1657)player, hand);
                table.method_5447(slot, result.toOther);
                Swap.placeLeftovers((class_1657)player, result.leftovers);
                class_1799[] ins = new class_1799[10];
                for (int i = 0; i <= 8; ++i) {
                    ins[i] = table.method_5438(i);
                    storage.items[i] = class_1799.field_8037;
                }
                ins[9] = class_1799.field_8037;
                class_3955 recipe = Swap.getRecipe(player, ins);
                storage.items[9] = recipe != null ? recipe.method_8110() : class_1799.field_8037;
            } else {
                int i;
                for (i = 0; i <= 8; ++i) {
                    storage.items[i] = table.method_5438(i).method_7972();
                }
                Swap.handleDoCraft(player, storage.items, tablePos);
                for (i = 0; i <= 8; ++i) {
                    table.method_5447(i, storage.items[i]);
                    storage.items[i] = class_1799.field_8037;
                }
            }
        } else {
            if (slot < 9) {
                playerItem = player.method_5998(hand);
                class_1799 craftingItem = storage.items[slot];
                SwapResult result = Swap.getSwap(playerItem, craftingItem, mode);
                storage.items[slot] = result.toOther;
                Swap.givePlayerItemSwap(result.toHand, playerItem, (class_1657)player, hand);
                Swap.placeLeftovers((class_1657)player, result.leftovers);
                class_3955 recipe = Swap.getRecipe(player, storage.items);
                storage.items[9] = recipe != null ? recipe.method_8110() : class_1799.field_8037;
            } else {
                Swap.handleDoCraft(player, storage.items, tablePos);
            }
            storage.wStorage.method_80();
        }
    }

    public static class_3955 getRecipe(class_3222 player, class_1799[] stacksIn) {
        int invDim = stacksIn.length == 10 ? 3 : 2;
        class_1715 inv = new class_1715((class_1703)new NullContainer(), invDim, invDim);
        for (int i = 0; i < stacksIn.length - 1; ++i) {
            inv.method_5447(i, stacksIn[i]);
        }
        Optional res = player.method_5682().method_3772().method_8132(class_3956.field_17545, (class_1263)inv, player.field_6002);
        return res.orElse(null);
    }

    public static void handleDoCraft(class_3222 player, class_1799[] stacksIn, class_2338 tablePos) {
        boolean isBackpack = stacksIn.length == 5;
        int invDim = isBackpack ? 2 : 3;
        class_1715 inv = new class_1715((class_1703)new NullContainer(), invDim, invDim);
        for (int i = 0; i < stacksIn.length - 1; ++i) {
            inv.method_5447(i, stacksIn[i]);
        }
        class_3955 res = Swap.getRecipe(player, stacksIn);
        if (res != null) {
            for (int i = 0; i < stacksIn.length - 1; ++i) {
                stacksIn[i].method_7934(1);
            }
            class_3955 newRecipe = Swap.getRecipe(player, stacksIn);
            stacksIn[stacksIn.length - 1] = newRecipe != null ? newRecipe.method_8110() : class_1799.field_8037;
            class_1799 stackOut = res.method_8116((class_1263)inv);
            class_1799 handStack = player.method_5998(class_1268.field_5808);
            class_1799 toGive = class_1799.field_8037;
            if (!handStack.method_7960() && Util.stacksEqualBesidesCount(stackOut, handStack)) {
                Util.ItemStackMergeResult itemRes = Util.mergeStacks(handStack, stackOut, true);
                player.method_6122(class_1268.field_5808, itemRes.mergedInto);
                toGive = itemRes.mergedFrom;
            } else if (handStack.method_7960()) {
                player.method_6122(class_1268.field_5808, stackOut);
            } else {
                toGive = stackOut;
            }
            if (!toGive.method_7960()) {
                class_2338 posBlock = tablePos != null ? tablePos.method_10084() : player.method_24515();
                class_243 pos = class_243.method_24953((class_2382)posBlock);
                class_1542 entOut = new class_1542(player.field_6002, pos.field_1352, pos.field_1351, pos.field_1350, toGive);
                entOut.method_18800(0.0, 0.0, 0.0);
                player.field_6002.method_8649((class_1297)entOut);
            } else {
                player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, isBackpack ? class_3419.field_15248 : class_3419.field_15245, 0.2f, ThreadLocalRandom.current().nextFloat() - ThreadLocalRandom.current().nextFloat() * 1.4f + 2.0f);
            }
        }
    }

    public static void handleInventorySwap(class_1657 player, int slot, class_1268 hand) {
        class_1799 handStack = player.method_5998(hand).method_7972();
        class_1799 invStack = player.method_31548().method_5438(slot).method_7972();
        if (handStack.method_7960() || invStack.method_7960() || !Util.stacksEqualBesidesCount(handStack, invStack)) {
            player.method_6122(hand, invStack);
            player.method_31548().method_5447(slot, handStack);
        } else {
            Util.ItemStackMergeResult res = Util.mergeStacks(invStack, handStack, false);
            player.method_6122(hand, res.mergedFrom);
            player.method_31548().method_5447(slot, res.mergedInto);
        }
    }

    public static void handleFurnaceSwap(class_1278 furnace, class_1657 player, class_1268 hand, int slot, PlacementMode mode) {
        class_1799 furnaceItem = furnace.method_5438(slot).method_7972();
        class_1799 playerItem = player.method_5998(hand).method_7972();
        if (slot != 2) {
            if (slot != 1 || furnace.method_5437(1, playerItem)) {
                SwapResult result = Swap.getSwap(playerItem, furnaceItem, mode);
                Swap.givePlayerItemSwap(result.toHand, playerItem, player, hand);
                furnace.method_5447(slot, result.toOther);
                Swap.placeLeftovers(player, result.leftovers);
            }
        } else if (playerItem.method_7960()) {
            player.method_6122(hand, furnaceItem);
            furnace.method_5447(2, playerItem);
        } else if (Util.stacksEqualBesidesCount(furnaceItem, playerItem)) {
            Util.ItemStackMergeResult result = Util.mergeStacks(playerItem, furnaceItem, false);
            player.method_6122(hand, result.mergedInto);
            furnace.method_5447(slot, result.mergedFrom);
        }
    }

    public static void handleBrewingSwap(class_2589 stand, class_1657 player, class_1268 hand, int slot, PlacementMode mode) {
        class_1799 standItem = stand.method_5438(slot).method_7972();
        class_1799 playerItem = player.method_5998(hand).method_7972();
        if (slot < 3) {
            if (!stand.method_5437(slot, playerItem) && playerItem != class_1799.field_8037 && !(standItem.method_7909() instanceof class_1812)) {
                return;
            }
            player.method_6122(hand, standItem);
            stand.method_5447(slot, playerItem);
        } else {
            if (!stand.method_5437(slot, playerItem) && playerItem != class_1799.field_8037) {
                return;
            }
            SwapResult result = Swap.getSwap(playerItem, standItem, mode);
            Swap.givePlayerItemSwap(result.toHand, playerItem, player, hand);
            stand.method_5447(slot, result.toOther);
            Swap.placeLeftovers(player, result.leftovers);
        }
    }

    public static void handleJukebox(class_2619 jukebox, class_3222 player, class_1268 hand) {
        class_1799 playerItem = player.method_5998(hand);
        if (jukebox.method_11275() == class_1799.field_8037 && playerItem.method_7909() instanceof class_1813) {
            ((class_2387)class_2246.field_10223).method_10276((class_1936)player.field_6002, jukebox.method_11016(), jukebox.method_11010(), playerItem);
            player.field_6002.method_8444((class_1657)null, 1010, jukebox.method_11016(), class_1792.method_7880((class_1792)playerItem.method_7909()));
            playerItem.method_7934(1);
            player.method_7281(class_3468.field_15375);
        }
    }

    public static void handleChest(class_2595 chestIn, class_1657 player, class_1268 hand, int slot) {
        class_2595 chest;
        class_2595 class_25952 = chest = slot > 26 ? Util.getOtherChest(chestIn) : chestIn;
        if (chest != null) {
            class_1799 chestItem = chest.method_5438(slot %= 27).method_7972();
            class_1799 playerItem = player.method_5998(hand);
            if (playerItem.method_7960() || chestItem.method_7960() || !Util.stacksEqualBesidesCount(chestItem, playerItem)) {
                player.method_6122(hand, chestItem);
                chest.method_5447(slot, playerItem);
            } else {
                Util.ItemStackMergeResult result = Util.mergeStacks(chestItem, playerItem, false);
                player.method_6122(hand, result.mergedFrom);
                chest.method_5447(slot, result.mergedInto);
            }
        }
    }

    public static void handleEnderChest(class_1657 player, class_1268 hand, int slot) {
        class_1799 chestItem = player.method_7274().method_5438(slot).method_7972();
        class_1799 playerItem = player.method_5998(hand);
        if (playerItem.method_7960() || chestItem.method_7960() || !Util.stacksEqualBesidesCount(chestItem, playerItem)) {
            player.method_6122(hand, chestItem);
            player.method_7274().method_5447(slot, playerItem);
        } else {
            Util.ItemStackMergeResult result = Util.mergeStacks(chestItem, playerItem, false);
            player.method_6122(hand, result.mergedFrom);
            player.method_7274().method_5447(slot, result.mergedInto);
        }
    }

    public static Pair<class_1799, Integer> getAnvilOutput(class_1799 left, class_1799 mid, boolean isReallyAnvil, class_3222 player) {
        Object container = isReallyAnvil ? new class_1706(-1, player.method_31548()) : new class_4862(-1, player.method_31548());
        container.method_7619(0, 0, left);
        container.method_7619(1, 0, mid);
        container.method_24928();
        class_1799 res = container.method_7611(2).method_7677();
        int level = 0;
        if (isReallyAnvil) {
            level = ((AnvilMenuMixin)container).getCost().method_17407();
        }
        return new Pair((Object)res, (Object)level);
    }

    public static SwapResult getSwap(class_1799 handIn, class_1799 otherIn, PlacementMode mode) {
        class_1799 leftovers;
        class_1799 toHand;
        class_1799 toOther;
        int toPlace = switch (mode) {
            case PlacementMode.PLACE_ONE -> 1;
            case PlacementMode.PLACE_QUARTER -> (int)Math.max((double)handIn.method_7947() / 4.0, 1.0);
            case PlacementMode.PLACE_HALF -> (int)Math.max((double)handIn.method_7947() / 2.0, 1.0);
            case PlacementMode.PLACE_ALL -> handIn.method_7947();
            default -> throw new IllegalArgumentException("Unhandled placement mode " + mode);
        };
        if (Util.stacksEqualBesidesCount(handIn, otherIn) && !handIn.method_7960() && !otherIn.method_7960()) {
            class_1799 handInCountAdjusted = handIn.method_7972();
            handInCountAdjusted.method_7939(toPlace);
            Util.ItemStackMergeResult mergeResult = Util.mergeStacks(otherIn.method_7972(), handInCountAdjusted, false);
            toOther = mergeResult.mergedInto;
            toHand = handIn.method_7972();
            toHand.method_7934(toPlace);
            toHand.method_7933(mergeResult.mergedFrom.method_7947());
            leftovers = class_1799.field_8037;
        } else {
            if (handIn.method_7960()) {
                return new SwapResult(otherIn.method_7972(), class_1799.field_8037, class_1799.field_8037);
            }
            toOther = handIn.method_7972();
            toOther.method_7939(toPlace);
            toHand = handIn.method_7972();
            toHand.method_7934(toPlace);
            leftovers = otherIn.method_7972();
        }
        return new SwapResult(toHand, toOther, leftovers);
    }

    public static void placeLeftovers(class_1657 player, class_1799 leftovers) {
        if (!leftovers.method_7960()) {
            class_1542 item = new class_1542(player.field_6002, player.method_23317(), player.method_23318(), player.method_23321(), leftovers);
            player.field_6002.method_8649((class_1297)item);
        }
    }

    public static void givePlayerItemSwap(class_1799 toPlayer, class_1799 fromPlayer, class_1657 player, class_1268 hand) {
        if (fromPlayer.method_7960() && toPlayer.method_7914() > 1) {
            Util.addStackToInventory(player, toPlayer);
        } else {
            player.method_6122(hand, toPlayer);
        }
    }

    public static class SwapResult {
        public final class_1799 toHand;
        public final class_1799 toOther;
        public final class_1799 leftovers;

        public SwapResult(class_1799 toHand, class_1799 toOther, class_1799 leftovers) {
            this.toHand = toHand;
            this.toOther = toOther;
            this.leftovers = leftovers;
        }
    }
}

