/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server.tracker;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.tracker.AbstractTracker;
import net.blf02.immersivemc.server.PlayerConfigs;
import net.blf02.immersivemc.server.tracker.ServerTrackerInit;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_2183;
import net.minecraft.class_243;
import net.minecraft.class_3222;

public class RangedGrabTrackerServer
extends AbstractTracker {
    public static final double moveMultiplier = 0.6666666666666666;
    public final List<RangedGrabInfo> infos = new ArrayList<RangedGrabInfo>();
    protected final List<RangedGrabInfo> toRemove = new LinkedList<RangedGrabInfo>();

    public RangedGrabTrackerServer() {
        ServerTrackerInit.globalTrackers.add(this);
    }

    @Override
    protected void tick(class_1657 player) {
        for (RangedGrabInfo info : this.infos) {
            if (info.item == null || !info.item.method_5805() || info.tickTime <= 0) {
                this.toRemove.add(info);
                continue;
            }
            if (!PlayerConfigs.getConfig((class_1657)info.player).useRangedGrab) {
                return;
            }
            --info.tickTime;
            info.item.method_6982(0);
            class_243 baseVelocity = new class_243(0.0, 0.0, 0.0);
            if (info.tickTime > 35) {
                baseVelocity = baseVelocity.method_1031(0.0, 0.25, 0.0);
            }
            info.item.method_5702(class_2183.class_2184.field_9851, info.player.method_19538().method_1031(0.0, 1.0, 0.0));
            class_243 move = info.item.method_5720().method_18805(0.6666666666666666, 0.6666666666666666, 0.6666666666666666).method_1019(baseVelocity);
            info.item.method_18800(move.field_1352, move.field_1351, move.field_1350);
            info.item.field_6037 = true;
        }
        for (RangedGrabInfo toRem : this.toRemove) {
            this.infos.remove(toRem);
        }
    }

    @Override
    protected boolean shouldTick(class_1657 player) {
        return ActiveConfig.useRangedGrab && this.infos.size() > 0;
    }

    public static class RangedGrabInfo {
        public final class_1542 item;
        public final class_3222 player;
        public int tickTime = 40;

        public RangedGrabInfo(class_1542 item, class_3222 player) {
            this.item = item;
            this.player = player;
        }
    }
}

