/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server.tracker.vrhand;

import java.util.HashMap;
import java.util.Map;
import net.blf02.immersivemc.common.config.ServerPlayerConfig;
import net.blf02.immersivemc.server.LastTickVRData;
import net.blf02.immersivemc.server.data.LastTickData;
import net.blf02.immersivemc.server.tracker.vrhand.AbstractVRHandTracker;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3965;

public class DoorMoveTracker
extends AbstractVRHandTracker {
    public static final double THRESHOLD = 0.06;
    public Map<String, Integer> cooldown = new HashMap<String, Integer>();

    @Override
    public void preTick(class_1657 player) {
        super.preTick(player);
        int newCooldown = this.cooldown.getOrDefault(player.method_7334().getName(), 0) - 1;
        if (newCooldown <= 0) {
            this.cooldown.remove(player.method_7334().getName());
        } else {
            this.cooldown.put(player.method_7334().getName(), newCooldown);
        }
    }

    @Override
    protected boolean shouldRunForHand(class_1657 player, class_1268 hand, class_1799 stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        class_2248 block = this.getBlockAtHand(player, currentVRData, hand);
        return this.cooldown.get(player.method_7334().getName()) == null && (block instanceof class_2349 || block instanceof class_2323);
    }

    @Override
    protected void runForHand(class_1657 player, class_1268 hand, class_1799 stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        boolean otherMoveCheck;
        class_2680 blockState = this.getBlockStateAtHand(player, currentVRData, hand);
        class_243 velocity = LastTickVRData.getVelocity(lastVRData.lastPlayer.getController(hand.ordinal()), currentVRData.getController(hand.ordinal()), lastVRData);
        class_2350 pushPullMainDirection = DoorMoveTracker.getDirectionToMove(blockState);
        boolean bl = otherMoveCheck = blockState.method_26204() instanceof class_2349 && this.movingInDirectionWithThreshold(pushPullMainDirection.method_10153(), velocity, 0.06);
        if (this.movingInDirectionWithThreshold(pushPullMainDirection, velocity, 0.06) || otherMoveCheck) {
            blockState.method_26174(player.field_6002, player, class_1268.field_5808, new class_3965(currentVRData.getController(hand.ordinal()).position(), pushPullMainDirection, this.getBlockPosAtHand(currentVRData, hand), false));
            this.cooldown.put(player.method_7334().getName(), 10);
        }
    }

    @Override
    public boolean isEnabledInConfig(ServerPlayerConfig config) {
        return config.useDoorImmersion;
    }

    public static class_2350 getDirectionToMove(class_2680 state) {
        boolean isOpen = (Boolean)state.method_11654((class_2769)class_2741.field_12537);
        return isOpen ? ((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10170() : (class_2350)state.method_11654((class_2769)class_2383.field_11177);
    }
}

