/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server.tracker.vrhand;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.blf02.immersivemc.common.config.ServerPlayerConfig;
import net.blf02.immersivemc.server.data.LastTickData;
import net.blf02.immersivemc.server.tracker.vrhand.AbstractVRHandsTracker;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;

public class FeedAnimalsTracker
extends AbstractVRHandsTracker {
    public static final int COOLDOWN_TICKS = 20;
    protected Map<String, Integer> cooldown = new HashMap<String, Integer>();

    @Override
    public boolean isEnabledInConfig(ServerPlayerConfig config) {
        return config.canFeedAnimals;
    }

    @Override
    protected boolean shouldRun(class_1657 player, IVRPlayer vrPlayer, LastTickData lastVRData) {
        int currentCooldown = this.cooldown.getOrDefault(player.method_7334().getName(), 0);
        if (currentCooldown > 0) {
            this.cooldown.put(player.method_7334().getName(), --currentCooldown);
        }
        return (!player.method_5998(class_1268.field_5808).method_7960() || !player.method_5998(class_1268.field_5810).method_7960()) && currentCooldown <= 0;
    }

    @Override
    protected void run(class_1657 player, IVRPlayer vrPlayer, LastTickData lastVRData) {
        class_1268 hand = player.method_5998(class_1268.field_5808).method_7960() ? class_1268.field_5810 : class_1268.field_5808;
        class_1799 inHand = player.method_5998(hand);
        if (inHand.method_7960()) {
            return;
        }
        List<class_1429> nearbyEnts = FeedAnimalsTracker.getLivingNearby(player);
        for (class_1429 animal : nearbyEnts) {
            class_1269 res;
            class_238 feedbox;
            if (!animal.method_6481(inHand) || !(feedbox = FeedAnimalsTracker.getMouthHitbox((class_1309)animal)).method_1006(vrPlayer.getController0().position()) || !feedbox.method_1006(vrPlayer.getController1().position()) || !(vrPlayer.getController0().position().method_1025(vrPlayer.getController1().position()) < 0.5) || (res = animal.method_5992(player, hand)) != class_1269.field_21466 && res != class_1269.field_5812) continue;
            this.cooldown.put(player.method_7334().getName(), 20);
            break;
        }
    }

    public static class_238 getMouthHitbox(class_1309 entity) {
        return class_238.method_30048((class_243)entity.method_33571(), (double)((double)entity.method_17681() * 2.25), (double)((double)entity.method_17682() * 0.5), (double)((double)entity.method_17681() * 2.25));
    }

    public static List<class_1429> getLivingNearby(class_1657 player) {
        class_238 checkArea = class_238.method_30048((class_243)player.method_19538(), (double)6.0, (double)6.0, (double)6.0);
        List ents = player.field_6002.method_8333((class_1297)player, checkArea, e -> e instanceof class_1429);
        LinkedList<class_1429> nearby = new LinkedList<class_1429>();
        for (class_1297 e2 : ents) {
            nearby.add((class_1429)e2);
        }
        return nearby;
    }
}

