/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.client.config.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.blf02.immersivemc.client.config.screen.ScreenUtils;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.config.ImmersiveMCConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class ImmersivesConfigScreen
extends Screen {
    protected final ScreenType type;
    protected final Screen lastScreen;
    protected OptionsList list;
    protected static int BUTTON_WIDTH = 128;
    protected static int BUTTON_HEIGHT = 20;

    public ImmersivesConfigScreen(Screen screen, ScreenType type) {
        super((Component)new TranslatableComponent("screen.immersivemc.immersives_config.title"));
        this.lastScreen = screen;
        this.type = type;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.canShowConfigScreen()) {
            this.initNotInWorld();
        }
        this.m_142416_((GuiEventListener)new Button((this.f_96543_ - BUTTON_WIDTH) / 2, this.f_96544_ - 26, BUTTON_WIDTH, BUTTON_HEIGHT, (Component)new TranslatableComponent("gui.done"), button -> this.m_7379_()));
    }

    protected void initNotInWorld() {
        this.list = new OptionsList(Minecraft.m_91087_(), this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 24);
        this.initOptionsList();
        this.m_142416_((GuiEventListener)this.list);
    }

    protected void initOptionsList() {
        if (this.type.isNonVR()) {
            ScreenUtils.addOption("anvil", ImmersiveMCConfig.useAnvilImmersion, this.list);
            ScreenUtils.addOption("brewing", ImmersiveMCConfig.useBrewingImmersion, this.list);
            ScreenUtils.addOption("chest", ImmersiveMCConfig.useChestImmersion, this.list);
            ScreenUtils.addOption("crafting", ImmersiveMCConfig.useCraftingImmersion, this.list);
            ScreenUtils.addOption("enchanting_table", ImmersiveMCConfig.useETableImmersion, this.list);
            ScreenUtils.addOption("furnace", ImmersiveMCConfig.useFurnaceImmersion, this.list);
            ScreenUtils.addOption("shulker", ImmersiveMCConfig.useShulkerImmersion, this.list);
        }
        if (this.type.isVR()) {
            ScreenUtils.addOption("animals", ImmersiveMCConfig.canFeedAnimals, this.list);
            ScreenUtils.addOption("armor", ImmersiveMCConfig.useArmorImmersion, this.list);
            ScreenUtils.addOption("backpack_button", ImmersiveMCConfig.useBackpack, this.list);
            ScreenUtils.addOption("button", ImmersiveMCConfig.useButton, this.list);
            ScreenUtils.addOption("campfire", ImmersiveMCConfig.useCampfireImmersion, this.list);
            ScreenUtils.addOption("door", ImmersiveMCConfig.useDoorImmersion, this.list);
            ScreenUtils.addOption("hoe", ImmersiveMCConfig.useHoeImmersion, this.list);
            ScreenUtils.addOption("jukebox", ImmersiveMCConfig.useJukeboxImmersion, this.list);
            ScreenUtils.addOption("lever", ImmersiveMCConfig.useLever, this.list);
            ScreenUtils.addOption("pet", ImmersiveMCConfig.canPet, this.list);
            ScreenUtils.addOption("ranged_grab", ImmersiveMCConfig.useRangedGrab, this.list);
            ScreenUtils.addOption("repeater", ImmersiveMCConfig.useRepeaterImmersion, this.list);
            ScreenUtils.addOption("shield", ImmersiveMCConfig.immersiveShield, this.list);
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        List list;
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        if (this.canShowConfigScreen()) {
            ImmersivesConfigScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
            TranslatableComponent translatableComponent = new TranslatableComponent("screen.immersivemc.immersives_config.subtitle");
            int n = this.f_96543_ / 2;
            Objects.requireNonNull(this.f_96547_);
            ImmersivesConfigScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)translatableComponent, (int)n, (int)(8 + 9), (int)0xFFFFFF);
        } else {
            ImmersivesConfigScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)new TranslatableComponent("screen.immersivemc.immersives_config.cant_change"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)0xFFFFFF);
        }
        if (this.list != null && (list = OptionsSubScreen.m_96287_((OptionsList)this.list, (int)mouseX, (int)mouseY)) != null) {
            this.m_96617_(stack, list, mouseX, mouseY);
        }
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.lastScreen);
        ActiveConfig.loadConfigFromFile();
        ActiveConfig.reloadAfterServer();
    }

    public boolean canShowConfigScreen() {
        return Minecraft.m_91087_().f_91073_ == null || ActiveConfig.serverCopy != null;
    }

    public static enum ScreenType {
        VR,
        NONVR,
        BOTH;


        public boolean isVR() {
            return this == VR || this == BOTH;
        }

        public boolean isNonVR() {
            return this == NONVR || this == BOTH;
        }
    }
}

