/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.client.immersive;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.blf02.immersivemc.client.immersive.Immersives;
import net.blf02.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import net.blf02.immersivemc.client.immersive.info.InfoTriggerHitboxes;
import net.blf02.immersivemc.client.model.Cube1x1;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.vr.VRPlugin;
import net.blf02.immersivemc.common.vr.VRPluginVerify;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractImmersive<I extends AbstractImmersiveInfo> {
    protected final List<I> infos;
    public final int maxImmersives;
    protected static final Cube1x1 cubeModel = new Cube1x1(Minecraft.m_91087_().m_167973_().m_171103_(Cube1x1.LAYER_LOCATION));
    protected boolean forceDisableItemGuide = false;

    public AbstractImmersive(int maxImmersives) {
        Immersives.IMMERSIVES.add(this);
        this.maxImmersives = maxImmersives;
        this.infos = new ArrayList<I>(maxImmersives > 0 ? maxImmersives + 1 : 16);
    }

    public boolean hitboxesAvailable(AbstractImmersiveInfo info) {
        return true;
    }

    public abstract boolean shouldRender(I var1, boolean var2);

    protected abstract void render(I var1, PoseStack var2, boolean var3);

    protected abstract boolean enabledInConfig();

    protected abstract boolean slotShouldRenderHelpHitbox(I var1, int var2);

    public abstract boolean shouldTrack(BlockPos var1, BlockState var2, BlockEntity var3, Level var4);

    public abstract void trackObject(BlockPos var1, BlockState var2, BlockEntity var3, Level var4);

    public abstract AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton();

    protected abstract void initInfo(I var1);

    public void onAnyRightClick(AbstractImmersiveInfo info) {
    }

    public boolean isVROnly() {
        return false;
    }

    public abstract void handleRightClick(AbstractImmersiveInfo var1, Player var2, int var3, InteractionHand var4);

    public void handleTriggerHitboxRightClick(InfoTriggerHitboxes info, Player player, int hitboxNum) {
    }

    public void onRemove(I info) {
    }

    protected boolean slotHelpBoxIsGreen(I info, int slotNum) {
        return ((AbstractImmersiveInfo)info).slotHovered == slotNum;
    }

    public void tick(I info, boolean isInVR) {
        if (this.enabledInConfig()) {
            if (!((AbstractImmersiveInfo)info).initCompleted) {
                this.initInfo(info);
                ((AbstractImmersiveInfo)info).initCompleted = true;
            }
            if (Minecraft.m_91087_().f_91073_ != null && this.shouldTrack(((AbstractImmersiveInfo)info).getBlockPosition(), Minecraft.m_91087_().f_91073_.m_8055_(((AbstractImmersiveInfo)info).getBlockPosition()), Minecraft.m_91087_().f_91073_.m_7702_(((AbstractImmersiveInfo)info).getBlockPosition()), (Level)Minecraft.m_91087_().f_91073_)) {
                this.doTick(info, isInVR);
                ((AbstractImmersiveInfo)info).setInputSlots();
            } else {
                ((AbstractImmersiveInfo)info).remove();
            }
        }
    }

    public int getCooldownVR() {
        return 12;
    }

    public int getCooldownDesktop() {
        return 8;
    }

    protected void doTick(I info, boolean isInVR) {
        if (((AbstractImmersiveInfo)info).getItemTransitionCountdown() > 1 && ((AbstractImmersiveInfo)info).getTicksLeft() > 20) {
            ((AbstractImmersiveInfo)info).changeItemTransitionCountdown(-1);
        } else if (((AbstractImmersiveInfo)info).getItemTransitionCountdown() < 20 && ((AbstractImmersiveInfo)info).getTicksLeft() <= 20) {
            ((AbstractImmersiveInfo)info).changeItemTransitionCountdown(1);
        }
        if (((AbstractImmersiveInfo)info).getTicksLeft() > 0) {
            ((AbstractImmersiveInfo)info).changeTicksLeft(-1);
        }
        ++((AbstractImmersiveInfo)info).ticksActive;
    }

    public void doRender(I info, PoseStack stack, boolean isInVR) {
        if (this.shouldRender(info, isInVR)) {
            try {
                this.render(info, stack, isInVR);
                if (ActiveConfig.showPlacementGuide && !this.forceDisableItemGuide) {
                    for (int i = 0; i < ((AbstractImmersiveInfo)info).getInputSlots().length; ++i) {
                        if (!this.slotShouldRenderHelpHitbox(info, i)) continue;
                        AABB itemBox = ((AbstractImmersiveInfo)info).getInputSlots()[i];
                        AABB toShow = itemBox.m_82386_(0.0, itemBox.m_82376_() / 2.0, 0.0);
                        this.renderItemGuide(stack, toShow, 0.2f, this.slotHelpBoxIsGreen(info, i));
                    }
                }
            }
            catch (NullPointerException | ConcurrentModificationException runtimeException) {
                // empty catch block
            }
        }
    }

    public List<I> getTrackedObjects() {
        return this.infos;
    }

    public void noInfosTick() {
    }

    public void renderItem(ItemStack item, PoseStack stack, Vec3 pos, float size, Direction facing, AABB hitbox, boolean renderItemCounts) {
        this.renderItem(item, stack, pos, size, facing, null, hitbox, renderItemCounts, -1);
    }

    public void renderItem(ItemStack item, PoseStack stack, Vec3 pos, float size, Direction facing, Direction upDown, AABB hitbox, boolean renderItemCounts, int spinDegrees) {
        Camera renderInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        if (item != null && item != ItemStack.f_41583_ && pos != null) {
            stack.m_85836_();
            stack.m_85837_(-renderInfo.m_90583_().f_82479_ + pos.f_82479_, -renderInfo.m_90583_().f_82480_ + pos.f_82480_, -renderInfo.m_90583_().f_82481_ + pos.f_82481_);
            stack.m_85841_(size, size, size);
            Vec3 textPos = pos;
            int degreesRotation = 0;
            if (spinDegrees > -1) {
                degreesRotation = spinDegrees;
            } else if (facing == Direction.WEST) {
                degreesRotation = 90;
            } else if (facing == Direction.SOUTH) {
                degreesRotation = 180;
            } else if (facing == Direction.EAST) {
                degreesRotation = 270;
            }
            int upDownRot = 0;
            if (upDown == Direction.UP) {
                upDownRot = 90;
                textPos = textPos.m_82520_(0.0, 0.15, 0.0);
            } else if (upDown == Direction.DOWN) {
                upDownRot = 270;
                textPos = textPos.m_82520_(0.0, -0.15, 0.0);
            } else if (facing == Direction.WEST) {
                textPos = textPos.m_82520_(-0.15, 0.0, 0.0);
            } else if (facing == Direction.SOUTH) {
                textPos = textPos.m_82520_(0.0, 0.0, 0.15);
            } else if (facing == Direction.EAST) {
                textPos = textPos.m_82520_(0.15, 0.0, 0.0);
            } else if (facing == Direction.NORTH) {
                textPos = textPos.m_82520_(0.0, 0.0, -0.15);
            } else if (facing == null) {
                stack.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
                stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                Vec3 textMove = VRPluginVerify.hasAPI && VRPluginVerify.clientInVR ? VRPlugin.API.getRenderVRPlayer().getHMD().getLookAngle() : Minecraft.m_91087_().f_91074_.m_20154_();
                textMove = textMove.m_82542_(-0.05, -0.05, -0.05);
                textPos = textPos.m_82549_(textMove);
            }
            if (facing != null) {
                stack.m_85845_(Vector3f.f_122225_.m_122240_((float)degreesRotation));
                stack.m_85845_(Vector3f.f_122223_.m_122240_((float)upDownRot));
            }
            ItemTransforms.TransformType type = facing == null ? ItemTransforms.TransformType.GROUND : ItemTransforms.TransformType.FIXED;
            Minecraft.m_91087_().m_91291_().m_174269_(item, type, 0xF000F0, OverlayTexture.f_118083_, stack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0);
            stack.m_85849_();
            if (renderItemCounts && item.m_41613_() > 1) {
                this.renderText((Component)new TextComponent(String.valueOf(item.m_41613_())), stack, textPos, facing == null ? 0.0025f : 0.01f);
            }
        }
        this.renderHitbox(stack, hitbox, pos);
    }

    protected void renderItemGuide(PoseStack stack, AABB hitbox, float alpha, boolean isGreen) {
        if (hitbox != null) {
            Camera renderInfo = Minecraft.m_91087_().f_91063_.m_109153_();
            Vec3 pos = hitbox.m_82399_();
            stack.m_85836_();
            stack.m_85837_(-renderInfo.m_90583_().f_82479_ + pos.f_82479_, -renderInfo.m_90583_().f_82480_ + pos.f_82480_, -renderInfo.m_90583_().f_82481_ + pos.f_82481_);
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            cubeModel.render(stack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)Cube1x1.textureLocation)), 0.0f, 1.0f, isGreen ? 0.0f : 1.0f, alpha, (float)(hitbox.m_82309_() / 2.0));
            stack.m_85849_();
        }
    }

    protected void renderHitbox(PoseStack stack, AABB hitbox, Vec3 pos) {
        this.renderHitbox(stack, hitbox, pos, false);
    }

    protected void renderHitbox(PoseStack stack, AABB hitbox, Vec3 pos, boolean alwaysRender) {
        AbstractImmersive.renderHitbox(stack, hitbox, pos, alwaysRender, 1.0f, 1.0f, 1.0f);
    }

    public static void renderHitbox(PoseStack stack, AABB hitbox, Vec3 pos, boolean alwaysRender, float red, float green, float blue) {
        if ((Minecraft.m_91087_().m_91290_().m_114377_() || alwaysRender) && hitbox != null && pos != null) {
            Camera renderInfo = Minecraft.m_91087_().f_91063_.m_109153_();
            stack.m_85836_();
            stack.m_85837_(-renderInfo.m_90583_().f_82479_ + pos.f_82479_, -renderInfo.m_90583_().f_82480_ + pos.f_82480_, -renderInfo.m_90583_().f_82481_ + pos.f_82481_);
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)hitbox.m_82386_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_), (float)red, (float)green, (float)blue, (float)1.0f);
            stack.m_85849_();
        }
    }

    public void renderText(Component text, PoseStack stack, Vec3 pos) {
        this.renderText(text, stack, pos, 0.02f);
    }

    public void renderText(Component text, PoseStack stack, Vec3 pos, float textSize) {
        Camera renderInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        stack.m_85836_();
        stack.m_85837_(-renderInfo.m_90583_().f_82479_ + pos.f_82479_, -renderInfo.m_90583_().f_82480_ + pos.f_82480_, -renderInfo.m_90583_().f_82481_ + pos.f_82481_);
        stack.m_85845_(renderInfo.m_90591_());
        stack.m_85841_(-textSize, -textSize, -textSize);
        Font font = Minecraft.m_91087_().f_91062_;
        float size = (float)(-font.m_92852_((FormattedText)text)) / 2.0f;
        font.m_92841_(text, size, 0.0f, -1, false, stack.m_85850_().m_85861_(), (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), false, 0, 0xF000F0);
        stack.m_85849_();
    }

    public Direction getLeftOfDirection(Direction forward) {
        if (forward == Direction.UP || forward == Direction.DOWN) {
            throw new IllegalArgumentException("Direction cannot be up or down!");
        }
        if (forward == Direction.NORTH) {
            return Direction.WEST;
        }
        if (forward == Direction.WEST) {
            return Direction.SOUTH;
        }
        if (forward == Direction.SOUTH) {
            return Direction.EAST;
        }
        return Direction.NORTH;
    }

    public Vec3 getDirectlyInFront(Direction forwardFromBlock, BlockPos pos) {
        if (forwardFromBlock == Direction.SOUTH) {
            BlockPos front = pos.m_142300_(forwardFromBlock);
            return new Vec3((double)front.m_123341_(), (double)front.m_123342_(), (double)front.m_123343_());
        }
        if (forwardFromBlock == Direction.WEST) {
            BlockPos front = pos;
            return new Vec3((double)front.m_123341_(), (double)front.m_123342_(), (double)front.m_123343_());
        }
        if (forwardFromBlock == Direction.NORTH) {
            BlockPos front = pos.m_142300_(Direction.EAST);
            return new Vec3((double)front.m_123341_(), (double)front.m_123342_(), (double)front.m_123343_());
        }
        if (forwardFromBlock == Direction.EAST) {
            BlockPos front = pos.m_142300_(Direction.SOUTH).m_142300_(Direction.EAST);
            return new Vec3((double)front.m_123341_(), (double)front.m_123342_(), (double)front.m_123343_());
        }
        throw new IllegalArgumentException("Furnaces can't point up or down?!?!");
    }

    public Vec3 getTopCenterOfBlock(BlockPos pos) {
        return Vec3.m_82514_((Vec3i)pos, (double)1.0);
    }

    public Direction getForwardFromPlayer(Player player) {
        return player.m_6350_().m_122424_();
    }

    public AABB createHitbox(Vec3 pos, float size) {
        return new AABB(pos.f_82479_ - (double)size, pos.f_82480_ - (double)size, pos.f_82481_ - (double)size, pos.f_82479_ + (double)size, pos.f_82480_ + (double)size, pos.f_82481_ + (double)size);
    }

    public Vec3[] get3x3HorizontalGrid(BlockPos blockPos, double spacing) {
        return this.get3x3HorizontalGrid(blockPos, spacing, this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_));
    }

    public Vec3[] get3x3HorizontalGrid(BlockPos blockPos, double spacing, Direction blockForward) {
        Vec3 pos = this.getTopCenterOfBlock(blockPos);
        Direction left = this.getLeftOfDirection(blockForward);
        Vec3 leftOffset = new Vec3((double)left.m_122436_().m_123341_() * -spacing, 0.0, (double)left.m_122436_().m_123343_() * -spacing);
        Vec3 rightOffset = new Vec3((double)left.m_122436_().m_123341_() * spacing, 0.0, (double)left.m_122436_().m_123343_() * spacing);
        Vec3 topOffset = new Vec3((double)blockForward.m_122436_().m_123341_() * -spacing, 0.0, (double)blockForward.m_122436_().m_123343_() * -spacing);
        Vec3 botOffset = new Vec3((double)blockForward.m_122436_().m_123341_() * spacing, 0.0, (double)blockForward.m_122436_().m_123343_() * spacing);
        return new Vec3[]{pos.m_82549_(leftOffset).m_82549_(topOffset), pos.m_82549_(topOffset), pos.m_82549_(rightOffset).m_82549_(topOffset), pos.m_82549_(leftOffset), pos, pos.m_82549_(rightOffset), pos.m_82549_(leftOffset).m_82549_(botOffset), pos.m_82549_(botOffset), pos.m_82549_(rightOffset).m_82549_(botOffset)};
    }

    public Vec3[] get3x3VerticalGrid(BlockPos blockPos, double spacing) {
        Vec3 posBotLeft = this.getDirectlyInFront(this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_), blockPos);
        Direction left = this.getLeftOfDirection(this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_));
        Vec3 pos = posBotLeft.m_82520_((double)left.m_122436_().m_123341_() * 0.5, 0.5, (double)left.m_122436_().m_123343_() * 0.5);
        Vec3 leftOffset = new Vec3((double)left.m_122436_().m_123341_() * -spacing, 0.0, (double)left.m_122436_().m_123343_() * -spacing);
        Vec3 rightOffset = new Vec3((double)left.m_122436_().m_123341_() * spacing, 0.0, (double)left.m_122436_().m_123343_() * spacing);
        Vec3 upOffset = new Vec3(0.0, spacing, 0.0);
        Vec3 downOffset = new Vec3(0.0, -spacing, 0.0);
        return new Vec3[]{pos.m_82549_(leftOffset).m_82549_(upOffset), pos.m_82549_(upOffset), pos.m_82549_(rightOffset).m_82549_(upOffset), pos.m_82549_(leftOffset), pos, pos.m_82549_(rightOffset), pos.m_82549_(leftOffset).m_82549_(downOffset), pos.m_82549_(downOffset), pos.m_82549_(rightOffset).m_82549_(downOffset)};
    }
}

