/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.client.immersive;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.blf02.immersivemc.client.immersive.AbstractImmersive;
import net.blf02.immersivemc.client.immersive.AbstractWorldStorageImmersive;
import net.blf02.immersivemc.client.immersive.Immersives;
import net.blf02.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import net.blf02.immersivemc.client.immersive.info.AbstractWorldStorageInfo;
import net.blf02.immersivemc.client.immersive.info.CraftingInfo;
import net.blf02.immersivemc.client.immersive.info.InfoTriggerHitboxes;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.packet.GetRecipePacket;
import net.blf02.immersivemc.common.network.packet.InteractPacket;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ImmersiveCrafting
extends AbstractWorldStorageImmersive<CraftingInfo> {
    private final double spacing = 0.1875;

    public ImmersiveCrafting() {
        super(2);
    }

    @Override
    protected void initInfo(CraftingInfo info) {
        this.setHitboxes(info);
    }

    protected void setHitboxes(CraftingInfo info) {
        Direction forward;
        Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        info.isTinkersTable = Minecraft.m_91087_().f_91073_.m_7702_(info.getBlockPosition()) != null;
        try {
            forward = info.isTinkersTable ? (Direction)Minecraft.m_91087_().f_91073_.m_8055_(info.getBlockPosition()).m_61143_((Property)BlockStateProperties.f_61374_) : this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
        }
        catch (IllegalArgumentException e) {
            forward = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
        }
        Vec3[] positions = this.get3x3HorizontalGrid(info.getBlockPosition(), 0.1875, forward);
        float hitboxSize = 0.0625f;
        for (int i = 0; i < 9; ++i) {
            info.setPosition(i, positions[i]);
            info.setHitbox(i, this.createHitbox(positions[i], hitboxSize));
        }
        info.outputPosition = info.getPosition(4).m_82520_(0.0, 0.5, 0.0);
        info.outputHitbox = this.createHitbox(info.outputPosition, hitboxSize * 3.0f);
        info.lastDir = forward;
    }

    @Override
    protected void doTick(CraftingInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        Direction forward = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
        if (info.lastDir != forward) {
            this.setHitboxes(info);
        }
        if (info.isTinkersTable && info.ticksActive % 4 == 0) {
            Network.INSTANCE.sendToServer((Object)new GetRecipePacket(info.getBlockPosition()));
        }
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int closest, InteractionHand hand) {
        Network.INSTANCE.sendToServer((Object)new InteractPacket(info.getBlockPosition(), closest, hand));
    }

    @Override
    public void handleTriggerHitboxRightClick(InfoTriggerHitboxes info, Player player, int hitboxNum) {
        AbstractImmersiveInfo aInfo = (AbstractImmersiveInfo)((Object)info);
        Network.INSTANCE.sendToServer((Object)new InteractPacket(aInfo.getBlockPosition(), 9, InteractionHand.MAIN_HAND));
        ((CraftingInfo)info).setTicksLeft(120);
    }

    @Override
    protected void render(CraftingInfo info, PoseStack stack, boolean isInVR) {
        float itemSize = 0.1875f / (float)info.getItemTransitionCountdown();
        Direction forward = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
        for (int i = 0; i < 9; ++i) {
            float renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
            this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, forward, Direction.UP, info.getHitbox(i), true, -1);
        }
        int degreesRotation = (int)((double)info.ticksActive % 100.0 * 3.6);
        this.renderItem(info.outputItem, stack, info.outputPosition, itemSize * 3.0f, forward, null, info.outputHitbox, true, ActiveConfig.spinCraftingOutput ? degreesRotation : -1);
    }

    @Override
    protected boolean enabledInConfig() {
        return ActiveConfig.useCraftingImmersion;
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isCraftingTable(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveCrafting;
    }

    @Override
    public void processStorageFromNetwork(AbstractWorldStorageInfo info, ImmersiveStorage storageIn) {
        for (int i = 0; i <= 8; ++i) {
            info.items[i] = storageIn.items[i];
        }
        CraftingInfo cInfo = (CraftingInfo)info;
        cInfo.outputItem = storageIn.items[9];
    }

    @Override
    public CraftingInfo getNewInfo(BlockPos pos) {
        return new CraftingInfo(pos, this.getTickTime());
    }

    @Override
    public int getTickTime() {
        return 120;
    }

    @Override
    public boolean shouldRender(CraftingInfo info, boolean isInVR) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        return level != null && level.m_8055_(info.getBlockPosition().m_7494_()).m_60795_() && info.readyToRender();
    }

    @Override
    public int getCooldownVR() {
        return 7;
    }
}

