/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.client.immersive;

import com.mojang.blaze3d.vertex.PoseStack;
import net.blf02.immersivemc.client.immersive.AbstractBlockEntityImmersive;
import net.blf02.immersivemc.client.immersive.AbstractImmersive;
import net.blf02.immersivemc.client.immersive.Immersives;
import net.blf02.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import net.blf02.immersivemc.client.immersive.info.ShulkerInfo;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.packet.ChestShulkerOpenPacket;
import net.blf02.immersivemc.common.network.packet.SwapPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ImmersiveShulker
extends AbstractBlockEntityImmersive<ShulkerBoxBlockEntity, ShulkerInfo> {
    public ImmersiveShulker() {
        super(4);
    }

    @Override
    public ShulkerInfo getNewInfo(BlockEntity tileEnt) {
        return new ShulkerInfo((ShulkerBoxBlockEntity)tileEnt, 300);
    }

    @Override
    public int getTickTime() {
        return 300;
    }

    @Override
    public boolean shouldRender(ShulkerInfo info, boolean isInVR) {
        return info.readyToRender() && info.isOpen;
    }

    @Override
    protected void render(ShulkerInfo info, PoseStack stack, boolean isInVR) {
        float itemSize = 0.2f / (float)info.getItemTransitionCountdown();
        for (int i = 0; i < 27; ++i) {
            float renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
            this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_), null, info.getHitbox(i), true, -1);
        }
    }

    @Override
    protected boolean enabledInConfig() {
        return ActiveConfig.useShulkerImmersion;
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isShulkerBox(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveShulker;
    }

    @Override
    protected void initInfo(ShulkerInfo info) {
        this.setHitboxes(info);
    }

    public void setHitboxes(ShulkerInfo info) {
        int i;
        Vec3[] positions = this.get3x3VerticalGrid(info.getBlockPosition(), 0.15);
        for (i = 0; i < 27; ++i) {
            info.setHitbox(i, null);
            info.setPosition(i, null);
        }
        for (i = 0; i < 9; ++i) {
            positions[i] = positions[i].m_82520_(0.0, 0.25, 0.0);
            info.setHitbox(i + info.getRowNum() * 9, this.createHitbox(positions[i], 0.075f));
            info.setPosition(i + info.getRowNum() * 9, positions[i]);
        }
        info.lastDir = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int closest, InteractionHand hand) {
        if (((ShulkerInfo)info).isOpen) {
            Network.INSTANCE.sendToServer((Object)new SwapPacket(info.getBlockPosition(), closest, hand));
        }
    }

    @Override
    protected void doTick(ShulkerInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        if (info.lastDir != this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_)) {
            this.setHitboxes(info);
        }
    }

    public static void openShulkerBox(ShulkerInfo info) {
        info.isOpen = !info.isOpen;
        Network.INSTANCE.sendToServer((Object)new ChestShulkerOpenPacket(info.getBlockPosition(), info.isOpen));
        if (!info.isOpen) {
            info.remove();
        }
    }

    @Override
    public boolean hitboxesAvailable(AbstractImmersiveInfo info) {
        return ((ShulkerInfo)info).isOpen;
    }
}

