/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.client.immersive.info;

import net.blf02.immersivemc.client.immersive.info.AbstractBlockEntityImmersiveInfo;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.phys.AABB;

public class BrewingInfo
extends AbstractBlockEntityImmersiveInfo<BrewingStandBlockEntity> {
    protected AABB fuelHitbox = null;
    protected AABB ingredientHitbox = null;
    protected AABB[] bottleHitboxes = new AABB[]{null, null, null};
    public Direction lastDir = null;

    public BrewingInfo(BrewingStandBlockEntity tileEntity, int ticksToExist) {
        super(tileEntity, ticksToExist, 4);
    }

    @Override
    public void setInputSlots() {
        this.inputHitboxes = this.getAllHitboxes();
    }

    @Override
    public AABB getHitbox(int slot) {
        if (slot < 0 || slot > 4) {
            throw new IllegalArgumentException("Only supports slots 0-4");
        }
        if (slot < 3) {
            return this.bottleHitboxes[slot];
        }
        if (slot == 3) {
            return this.ingredientHitbox;
        }
        return this.fuelHitbox;
    }

    @Override
    public AABB[] getAllHitboxes() {
        return new AABB[]{this.bottleHitboxes[0], this.bottleHitboxes[1], this.bottleHitboxes[2], this.ingredientHitbox, this.fuelHitbox};
    }

    @Override
    public void setHitbox(int slot, AABB hitbox) {
        if (slot < 0 || slot > 4) {
            throw new IllegalArgumentException("Only supports slots 0-4");
        }
        if (slot < 3) {
            this.bottleHitboxes[slot] = hitbox;
        } else if (slot == 3) {
            this.ingredientHitbox = hitbox;
        } else {
            this.fuelHitbox = hitbox;
        }
    }

    @Override
    public boolean hasHitboxes() {
        return this.fuelHitbox != null;
    }
}

