/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.client.tracker;

import com.mojang.math.Vector3f;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.blf02.immersivemc.client.tracker.ClientTrackerInit;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.packet.GrabItemPacket;
import net.blf02.immersivemc.common.tracker.AbstractTracker;
import net.blf02.immersivemc.common.util.Util;
import net.blf02.immersivemc.common.vr.VRPlugin;
import net.blf02.immersivemc.common.vr.VRPluginVerify;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RangedGrabTrackerClient
extends AbstractTracker {
    public static final double threshold = 0.1;
    protected IVRData last = null;
    protected ItemEntity selected = null;

    public RangedGrabTrackerClient() {
        ClientTrackerInit.trackers.add(this);
    }

    @Override
    protected void tick(Player player) {
        double dist;
        IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer(player);
        IVRData controller = vrPlayer.getController0();
        double d = dist = ActiveConfig.rangedGrabRange == -1 ? (double)Minecraft.m_91087_().f_91072_.m_105286_() : (double)ActiveConfig.rangedGrabRange;
        if (this.last != null) {
            if (Minecraft.m_91087_().f_91066_.f_92096_.m_90857_()) {
                if (controller.position().f_82480_ - this.last.position().f_82480_ > 0.1 && this.selected != null) {
                    Network.INSTANCE.sendToServer((Object)new GrabItemPacket(this.selected));
                    this.selected = null;
                }
            } else {
                this.selected = null;
                Vec3 start = controller.position();
                Vec3 viewVec = controller.getLookAngle();
                Vec3 end = start.m_82520_(viewVec.f_82479_ * dist, viewVec.f_82480_ * dist, viewVec.f_82481_ * dist);
                List ents = player.f_19853_.m_6249_((Entity)player, player.m_142469_().m_82400_(10.0), entity -> entity instanceof ItemEntity && Util.canPickUpItem((ItemEntity)entity, player));
                LinkedList<AABB> hitboxes = new LinkedList<AABB>();
                for (Entity ent : ents) {
                    hitboxes.add(ent.m_142469_().m_82400_(0.3333333333333333));
                }
                Optional<Integer> result = Util.rayTraceClosest(start, end, hitboxes.toArray(new AABB[0]));
                if (result.isPresent()) {
                    this.selected = (ItemEntity)ents.get(result.get());
                }
            }
        }
        if (this.selected != null) {
            Vec3 pos = this.selected.m_20182_().m_82520_(0.0, 0.2, 0.0);
            this.selected.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 1.0f, 1.0f), 1.0f), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.01, 0.01, 0.01);
        }
        this.last = controller;
    }

    @Override
    protected boolean shouldTick(Player player) {
        return VRPluginVerify.clientInVR && Minecraft.m_91087_().f_91072_ != null && ActiveConfig.useRangedGrab && VRPlugin.API.apiActive(player);
    }
}

