/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.common.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.NetworkClientHandlers;
import net.blf02.immersivemc.common.network.NetworkUtil;
import net.blf02.immersivemc.common.network.packet.UpdateStoragePacket;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.server.storage.GetStorage;
import net.blf02.immersivemc.server.storage.ImmersiveMCLevelStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;

public class FetchInventoryPacket {
    public final ItemStack[] items;
    public final BlockPos pos;

    public FetchInventoryPacket(BlockPos pos) {
        this(null, pos);
    }

    public FetchInventoryPacket(ItemStack[] items, BlockPos pos) {
        this.items = items;
        this.pos = pos;
    }

    public boolean isRequest() {
        return this.items != null;
    }

    public static void encode(FetchInventoryPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.writeBoolean(packet.isRequest());
        if (packet.isRequest()) {
            buffer.writeInt(packet.items.length);
            for (ItemStack s : packet.items) {
                buffer.m_130055_(s);
            }
        }
    }

    public static FetchInventoryPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        ItemStack[] stacks = null;
        if (buffer.readBoolean()) {
            int size = buffer.readInt();
            stacks = new ItemStack[size];
            for (int i = 0; i < size; ++i) {
                stacks[i] = buffer.m_130267_();
            }
        }
        return new FetchInventoryPacket(stacks, pos);
    }

    public static void handle(FetchInventoryPacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            ServerPlayer player;
            ServerPlayer serverPlayer = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof ServerPlayer ? (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player != null) {
                FetchInventoryPacket.handleServerToClient(player, message.pos);
            } else {
                NetworkClientHandlers.handleReceiveInvData(message.items, message.pos);
            }
        });
    }

    public static void handleServerToClient(ServerPlayer player, BlockPos pos) {
        if (NetworkUtil.safeToRun(pos, player)) {
            BlockEntity tileEnt = player.f_19853_.m_7702_(pos);
            if (ImmersiveMCLevelStorage.usesWorldStorage(pos, player.f_19853_.m_8055_(pos), tileEnt, player.f_19853_)) {
                ImmersiveStorage storage = GetStorage.getStorage((Player)player, pos);
                if (storage != null) {
                    Network.INSTANCE.sendToPlayer(player, (Object)new UpdateStoragePacket(pos, storage, storage.getType()));
                }
            } else if (tileEnt != null) {
                Container inv;
                if (tileEnt instanceof Container) {
                    inv = (Container)tileEnt;
                } else if (tileEnt instanceof EnderChestBlockEntity) {
                    inv = player.m_36327_();
                } else {
                    return;
                }
                ItemStack[] stacks = new ItemStack[inv.m_6643_()];
                for (int i = 0; i < inv.m_6643_(); ++i) {
                    stacks[i] = inv.m_8020_(i);
                }
                Network.INSTANCE.sendToPlayer(player, (Object)new FetchInventoryPacket(stacks, pos));
            }
        }
    }
}

