/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.common.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.config.ServerPlayerConfig;
import net.blf02.immersivemc.common.util.Util;
import net.blf02.immersivemc.server.PlayerConfigs;
import net.blf02.immersivemc.server.tracker.RangedGrabTrackerServer;
import net.blf02.immersivemc.server.tracker.ServerTrackerInit;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;

public class GrabItemPacket {
    public final int entityId;

    public GrabItemPacket(ItemEntity item) {
        this.entityId = item.m_142049_();
    }

    public GrabItemPacket(int entityId) {
        this.entityId = entityId;
    }

    public static void encode(GrabItemPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.entityId);
    }

    public static GrabItemPacket decode(FriendlyByteBuf buffer) {
        return new GrabItemPacket(buffer.readInt());
    }

    public static void handle(GrabItemPacket packet, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            ServerPlayer player;
            if (!ActiveConfig.useRangedGrab) {
                return;
            }
            ServerPlayer serverPlayer = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof ServerPlayer ? (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player != null) {
                Entity ent = player.f_19853_.m_6815_(packet.entityId);
                ServerPlayerConfig config = PlayerConfigs.getConfig((Player)player);
                int range = config.rangedGrabRange == -1 ? 5 : (config.rangedGrabRange + 1) * 2;
                if (ent instanceof ItemEntity && player.m_20280_(ent) <= (double)(range * range) && Util.canPickUpItem((ItemEntity)ent, (Player)player)) {
                    ItemEntity item = (ItemEntity)ent;
                    ServerTrackerInit.rangedGrabTracker.infos.add(new RangedGrabTrackerServer.RangedGrabInfo(item, player));
                }
            }
        });
    }
}

