/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.common.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.blf02.immersivemc.client.SafeClientUtil;
import net.blf02.immersivemc.common.config.PlacementMode;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.network.NetworkUtil;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.server.storage.GetStorage;
import net.blf02.immersivemc.server.swap.Swap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class InteractPacket {
    public final BlockPos pos;
    public final String storageKey;
    public final int slot;
    public final InteractionHand hand;
    public PlacementMode placementMode = SafeClientUtil.getPlacementMode();

    public InteractPacket(BlockPos pos, int slot, InteractionHand hand) {
        this.pos = pos;
        this.slot = slot;
        this.hand = hand;
        this.storageKey = null;
    }

    public InteractPacket(String storageKey, int slot, InteractionHand hand) {
        this.storageKey = storageKey;
        this.slot = slot;
        this.hand = hand;
        this.pos = null;
        if (storageKey.equals("backpack")) {
            this.placementMode = SafeClientUtil.getPlacementMode(true);
        }
    }

    protected InteractPacket setPlacementMode(PlacementMode mode) {
        this.placementMode = mode;
        return this;
    }

    public boolean isPlayerStorageInteract() {
        return this.storageKey != null;
    }

    public static void encode(InteractPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)packet.placementMode);
        buffer.writeBoolean(packet.isPlayerStorageInteract());
        if (packet.isPlayerStorageInteract()) {
            buffer.m_130070_(packet.storageKey);
        } else {
            buffer.m_130064_(packet.pos);
        }
        buffer.writeInt(packet.slot).writeInt(packet.hand == InteractionHand.MAIN_HAND ? 0 : 1);
    }

    public static InteractPacket decode(FriendlyByteBuf buffer) {
        PlacementMode mode = (PlacementMode)buffer.m_130066_(PlacementMode.class);
        if (buffer.readBoolean()) {
            return new InteractPacket(buffer.m_130277_(), buffer.readInt(), buffer.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND).setPlacementMode(mode);
        }
        return new InteractPacket(buffer.m_130135_(), buffer.readInt(), buffer.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND).setPlacementMode(mode);
    }

    public static void handle(InteractPacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            ServerPlayer player;
            ServerPlayer serverPlayer = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof ServerPlayer ? (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (message.isPlayerStorageInteract()) {
                if (message.storageKey.equals("backpack")) {
                    ImmersiveStorage storage = GetStorage.getPlayerStorage((Player)player, "backpack");
                    Swap.handleBackpackCraftingSwap(message.slot - 27, message.hand, storage, player, message.placementMode);
                }
            } else if (NetworkUtil.safeToRun(message.pos, player)) {
                BlockEntity tileEnt;
                BlockState state = player.f_19853_.m_8055_(message.pos);
                if (ImmersiveCheckers.isCraftingTable(message.pos, state, tileEnt = player.f_19853_.m_7702_(message.pos), player.f_19853_)) {
                    Swap.handleCraftingSwap(player, message.slot, message.hand, message.pos, message.placementMode);
                } else if (ImmersiveCheckers.isAnvil(message.pos, state, tileEnt, player.f_19853_)) {
                    Swap.anvilSwap(message.slot, message.hand, message.pos, player, message.placementMode);
                } else if (ImmersiveCheckers.isEnchantingTable(message.pos, state, tileEnt, player.f_19853_)) {
                    Swap.enchantingTableSwap(player, message.slot, message.hand, message.pos);
                }
            }
        });
    }
}

