/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.common.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.blf02.immersivemc.client.SafeClientUtil;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.config.PlacementMode;
import net.blf02.immersivemc.server.swap.Swap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;

public class InventorySwapPacket {
    public final int slot;
    public PlacementMode placementMode = SafeClientUtil.getPlacementMode();

    public InventorySwapPacket(int invSlotRaw) {
        this.slot = invSlotRaw;
    }

    public static void encode(InventorySwapPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)packet.placementMode).writeInt(packet.slot);
    }

    public static InventorySwapPacket decode(FriendlyByteBuf buffer) {
        PlacementMode mode = (PlacementMode)buffer.m_130066_(PlacementMode.class);
        InventorySwapPacket packet = new InventorySwapPacket(buffer.readInt());
        packet.placementMode = mode;
        return packet;
    }

    public static void handle(InventorySwapPacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            ServerPlayer player;
            if (!ActiveConfig.useBackpack) {
                return;
            }
            ServerPlayer serverPlayer = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof ServerPlayer ? (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player != null) {
                Swap.handleInventorySwap((Player)player, message.slot, InteractionHand.MAIN_HAND);
            }
        });
    }
}

