/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server;

import dev.architectury.event.EventResult;
import dev.architectury.utils.value.IntValue;
import java.util.List;
import net.blf02.immersivemc.ImmersiveMC;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.immersive.CheckerFunction;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.network.Network;
import net.blf02.immersivemc.common.network.packet.ConfigSyncPacket;
import net.blf02.immersivemc.common.network.packet.ImmersiveBreakPacket;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.common.tracker.AbstractTracker;
import net.blf02.immersivemc.common.vr.VRPluginVerify;
import net.blf02.immersivemc.server.ChestToOpenCount;
import net.blf02.immersivemc.server.storage.GetStorage;
import net.blf02.immersivemc.server.storage.ImmersiveMCLevelStorage;
import net.blf02.immersivemc.server.tracker.ServerTrackerInit;
import net.blf02.immersivemc.server.tracker.ServerVRSubscriber;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ServerSubscriber {
    /*
     * WARNING - void declaration
     */
    public static EventResult blockBreak(Level level, BlockPos pos, BlockState state, ServerPlayer player, @Nullable IntValue xp) {
        Object storage;
        if (level.f_46443_) {
            return EventResult.pass();
        }
        ServerLevel world = (ServerLevel)level;
        boolean sendBreakPacket = false;
        if (ImmersiveMCLevelStorage.usesWorldStorage(pos, state, world.m_7702_(pos), (Level)world) && (storage = ImmersiveMCLevelStorage.getLevelStorage(world).remove(pos)) != null) {
            void var8_9;
            boolean bl = false;
            while (var8_9 <= GetStorage.getLastInputIndex(pos, state, world.m_7702_(pos), (Level)world)) {
                Vec3 vecPos = Vec3.m_82512_((Vec3i)pos);
                ItemStack stack = ((ImmersiveStorage)storage).items[var8_9];
                if (stack != null && !stack.m_41619_()) {
                    ItemEntity itemEnt = new ItemEntity(level, vecPos.f_82479_, vecPos.f_82480_, vecPos.f_82481_, stack);
                    level.m_7967_((Entity)itemEnt);
                }
                ++var8_9;
            }
        }
        for (CheckerFunction checkerFunction : ImmersiveCheckers.CHECKERS) {
            if (!((Boolean)checkerFunction.apply(pos, level.m_8055_(pos), level.m_7702_(pos), level)).booleanValue()) continue;
            sendBreakPacket = true;
            break;
        }
        if (sendBreakPacket) {
            AABB nearbyBox = AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)pos), (double)20.0, (double)20.0, (double)20.0);
            List list = level.m_45976_(ServerPlayer.class, nearbyBox);
            Network.INSTANCE.sendToPlayers((Iterable)list, (Object)new ImmersiveBreakPacket(pos));
            ChestToOpenCount.chestImmersiveOpenCount.remove(pos);
        }
        return EventResult.pass();
    }

    public static void onServerTick(MinecraftServer server) {
        for (AbstractTracker tracker : ServerTrackerInit.globalTrackers) {
            tracker.doTick(null);
        }
        if (ActiveConfig.clientForceServerReloadForLAN) {
            ImmersiveMC.LOGGER.debug("Force-reloading config due to singleplayer config change!");
            ActiveConfig.loadConfigFromFile(true);
            ImmersiveMC.LOGGER.debug("Sending new config to all players.");
            Network.INSTANCE.sendToPlayers((Iterable)server.m_6846_().m_11314_(), (Object)new ConfigSyncPacket());
            ActiveConfig.clientForceServerReloadForLAN = false;
        }
    }

    public static void onPlayerTick(Player player) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        for (AbstractTracker tracker : ServerTrackerInit.playerTrackers) {
            tracker.doTick(player);
        }
        if (VRPluginVerify.hasAPI) {
            ServerVRSubscriber.vrPlayerTick(player);
        }
    }

    public static void onPlayerJoin(Player player) {
        if (!player.f_19853_.f_46443_ && player instanceof ServerPlayer) {
            ActiveConfig.loadConfigFromFile(true);
            Network.INSTANCE.sendToPlayer((ServerPlayer)player, (Object)new ConfigSyncPacket());
        }
    }
}

