/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server.storage;

import java.util.List;
import net.blf02.immersivemc.common.immersive.ImmersiveCheckers;
import net.blf02.immersivemc.common.storage.AnvilStorage;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.server.storage.ImmersiveMCLevelStorage;
import net.blf02.immersivemc.server.storage.ImmersiveMCPlayerStorages;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;

public class GetStorage {
    public static ImmersiveStorage assembleStorage(CompoundTag nbt, String storageType, SavedData wStorage) {
        ImmersiveStorage storage = null;
        if (storageType.equals("basic_item_store")) {
            storage = new ImmersiveStorage(wStorage);
            storage.load(nbt);
        } else if (storageType.equals("anvil_store")) {
            storage = new AnvilStorage(wStorage);
            storage.load(nbt);
        }
        if (storage == null) {
            throw new IllegalArgumentException("Storage type " + storageType + " does not exist!");
        }
        return storage;
    }

    public static int getLastInputIndex(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        if (ImmersiveCheckers.isCraftingTable(pos, state, tileEntity, level)) {
            return 8;
        }
        if (ImmersiveCheckers.isAnvil(pos, state, tileEntity, level)) {
            return 1;
        }
        if (ImmersiveCheckers.isEnchantingTable(pos, state, tileEntity, level)) {
            return 0;
        }
        return -1;
    }

    public static ImmersiveStorage getPlayerStorage(Player player, String playerStorageKey) {
        List<ImmersiveStorage> storages = ImmersiveMCPlayerStorages.getStorages(player);
        for (ImmersiveStorage storage : storages) {
            if (!storage.identifier.equals("backpack")) continue;
            return storage;
        }
        if (playerStorageKey.equals("backpack")) {
            ImmersiveStorage storage = new ImmersiveStorage(ImmersiveMCPlayerStorages.getPlayerStorage(player)).initIfNotAlready(5);
            storage.identifier = "backpack";
            ImmersiveMCPlayerStorages.getStorages(player).add(storage);
            ImmersiveMCPlayerStorages.getPlayerStorage(player).m_77762_();
            return storage;
        }
        throw new IllegalArgumentException("Invalid player storage type!");
    }

    public static ImmersiveStorage getStorage(Player player, BlockPos pos) {
        BlockEntity tileEnt;
        BlockState state = player.f_19853_.m_8055_(pos);
        if (ImmersiveCheckers.isCraftingTable(pos, state, tileEnt = player.f_19853_.m_7702_(pos), player.f_19853_)) {
            return GetStorage.getCraftingStorage(player, pos);
        }
        if (ImmersiveCheckers.isAnvil(pos, state, tileEnt, player.f_19853_)) {
            return GetStorage.getAnvilStorage(player, pos);
        }
        if (ImmersiveCheckers.isEnchantingTable(pos, state, tileEnt, player.f_19853_)) {
            return GetStorage.getEnchantingStorage(player, pos);
        }
        return null;
    }

    public static ImmersiveStorage getEnchantingStorage(Player player, BlockPos pos) {
        return ImmersiveMCLevelStorage.getLevelStorage(player).getOrCreate(pos).initIfNotAlready(1);
    }

    public static AnvilStorage getAnvilStorage(Player player, BlockPos pos) {
        AnvilStorage storage;
        ImmersiveMCLevelStorage wStorage = ImmersiveMCLevelStorage.getLevelStorage(player);
        ImmersiveStorage storageOld = wStorage.get(pos);
        if (!(storageOld instanceof AnvilStorage)) {
            storage = new AnvilStorage(wStorage);
            storage.initIfNotAlready(3);
            ImmersiveMCLevelStorage.getLevelStorage(player).add(pos, storage);
        } else {
            storage = (AnvilStorage)storageOld;
        }
        return storage;
    }

    public static ImmersiveStorage getCraftingStorage(Player player, BlockPos pos) {
        return ImmersiveMCLevelStorage.getLevelStorage(player).getOrCreate(pos).initIfNotAlready(10);
    }
}

