/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.blf02.immersivemc.common.storage.ImmersiveStorage;
import net.blf02.immersivemc.server.storage.GetStorage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class ImmersiveMCPlayerStorages
extends SavedData {
    protected Map<UUID, List<ImmersiveStorage>> playerStorages = new HashMap<UUID, List<ImmersiveStorage>>();

    private static ImmersiveMCPlayerStorages create() {
        return new ImmersiveMCPlayerStorages();
    }

    public static List<ImmersiveStorage> getStorages(Player player) {
        List<ImmersiveStorage> immersiveStorages = ImmersiveMCPlayerStorages.getPlayerStorage((Player)player).playerStorages.get(player.m_142081_());
        if (immersiveStorages == null) {
            immersiveStorages = new ArrayList<ImmersiveStorage>();
            ImmersiveMCPlayerStorages.getPlayerStorage((Player)player).playerStorages.put(player.m_142081_(), immersiveStorages);
        }
        return immersiveStorages;
    }

    public static ImmersiveMCPlayerStorages getPlayerStorage(Player player) {
        if (!player.f_19853_.f_46443_) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            return (ImmersiveMCPlayerStorages)sPlayer.m_20194_().m_129783_().m_8895_().m_164861_(ImmersiveMCPlayerStorages::load, ImmersiveMCPlayerStorages::create, "immersivemc_player_data");
        }
        throw new IllegalArgumentException("Can only access storage on server-side!");
    }

    public static ImmersiveMCPlayerStorages load(CompoundTag nbt) {
        ImmersiveMCPlayerStorages playerStorage = new ImmersiveMCPlayerStorages();
        Set keys = nbt.m_128431_();
        for (String uuidStr : keys) {
            UUID uuid = UUID.fromString(uuidStr);
            CompoundTag playerTag = nbt.m_128469_(uuidStr);
            CompoundTag storagesTag = playerTag.m_128469_("storages");
            int numStorages = storagesTag.m_128451_("numStorages");
            ArrayList<ImmersiveStorage> storages = new ArrayList<ImmersiveStorage>();
            for (int i = 0; i < numStorages; ++i) {
                CompoundTag storageInfo = storagesTag.m_128469_(String.valueOf(i));
                String storageType = storageInfo.m_128461_("dataType");
                ImmersiveStorage storage = GetStorage.assembleStorage(storageInfo.m_128469_("data"), storageType, playerStorage);
                storages.add(storage);
            }
            playerStorage.playerStorages.put(uuid, storages);
        }
        return playerStorage;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        for (Map.Entry<UUID, List<ImmersiveStorage>> entry : this.playerStorages.entrySet()) {
            CompoundTag playerTag = new CompoundTag();
            CompoundTag storagesTag = new CompoundTag();
            int numStorages = entry.getValue().size();
            storagesTag.m_128405_("numStorages", numStorages);
            for (int i = 0; i < numStorages; ++i) {
                CompoundTag storageInfo = new CompoundTag();
                storageInfo.m_128365_("data", (Tag)entry.getValue().get(i).save(new CompoundTag()));
                storageInfo.m_128359_("dataType", entry.getValue().get(i).getType());
                storagesTag.m_128365_(String.valueOf(i), (Tag)storageInfo);
            }
            playerTag.m_128365_("storages", (Tag)storagesTag);
            nbt.m_128365_(entry.getKey().toString(), (Tag)playerTag);
        }
        return nbt;
    }
}

