/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server.tracker;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.blf02.immersivemc.common.config.ActiveConfig;
import net.blf02.immersivemc.common.tracker.AbstractTracker;
import net.blf02.immersivemc.common.vr.VRPlugin;
import net.blf02.immersivemc.common.vr.VRPluginVerify;
import net.blf02.immersivemc.server.PlayerConfigs;
import net.blf02.immersivemc.server.tracker.ServerTrackerInit;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CampfireTracker
extends AbstractTracker {
    public static final Map<String, CookInfo> cookTime = new HashMap<String, CookInfo>();

    public CampfireTracker() {
        ServerTrackerInit.playerTrackers.add(this);
    }

    @Override
    protected void tick(Player player) {
        CookInfo info = cookTime.get(player.m_36316_().getName());
        if (info == null) {
            return;
        }
        for (int c = 0; c <= 1; ++c) {
            ItemStack toSmelt = c == 0 ? player.m_21120_(InteractionHand.MAIN_HAND) : player.m_21120_(InteractionHand.OFF_HAND);
            Optional recipe = player.f_19853_.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{toSmelt}), player.f_19853_);
            if (recipe.isPresent() && info.get(c) >= ((CampfireCookingRecipe)recipe.get()).m_43753_() / 2) {
                boolean didGive = player.m_150109_().m_36054_(((CampfireCookingRecipe)recipe.get()).m_8043_());
                if (didGive) {
                    toSmelt.m_41774_(1);
                }
                cookTime.remove(player.m_36316_().getName());
                continue;
            }
            if (!recipe.isPresent() || ThreadLocalRandom.current().nextInt(4) != 0) continue;
            Vec3 pos = VRPlugin.API.getVRPlayer(player).getController(c).position();
            Level level = player.f_19853_;
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.01, 0.01, 0.01, 0.0);
        }
    }

    @Override
    protected boolean shouldTick(Player player) {
        if (!ActiveConfig.useCampfireImmersion) {
            return false;
        }
        if (!VRPluginVerify.hasAPI) {
            return false;
        }
        if (!VRPlugin.API.playerInVR(player)) {
            return false;
        }
        if (!PlayerConfigs.getConfig((Player)player).useCampfire) {
            return false;
        }
        IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer(player);
        boolean mainRes = false;
        boolean offRes = false;
        for (int c = 0; c <= 1; ++c) {
            ItemStack stackOld;
            BlockState campfire;
            IVRData controller = vrPlayer.getController(c);
            BlockPos pos = new BlockPos(controller.position());
            if (!(player.f_19853_.m_8055_(pos).m_60734_() instanceof CampfireBlock) && !(player.f_19853_.m_8055_(pos.m_7495_()).m_60734_() instanceof CampfireBlock) || !((Boolean)(campfire = player.f_19853_.m_8055_(pos).m_60734_() instanceof CampfireBlock ? player.f_19853_.m_8055_(pos) : player.f_19853_.m_8055_(pos.m_7495_())).m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) continue;
            ItemStack stackNew = c == 0 ? player.m_21120_(InteractionHand.MAIN_HAND) : player.m_21120_(InteractionHand.OFF_HAND);
            CookInfo info = cookTime.get(player.m_36316_().getName());
            if (info == null) {
                info = new CookInfo();
                cookTime.put(player.m_36316_().getName(), info);
            }
            if (stackNew == (stackOld = info.getStack(c)) || stackOld.m_41619_()) {
                info.add(c, 1);
                if (c == 0) {
                    mainRes = true;
                } else {
                    offRes = true;
                }
            }
            info.setStack(c, stackNew);
        }
        return mainRes || offRes;
    }

    public static class CookInfo {
        protected int mainHand = 0;
        protected int offHand = 0;
        public ItemStack stackHeldMain = ItemStack.f_41583_;
        public ItemStack stackHeldOff = ItemStack.f_41583_;

        public void set(int controller, int value) {
            if (controller == 0) {
                this.mainHand = value;
            } else {
                this.offHand = value;
            }
        }

        public int get(int controller) {
            return controller == 0 ? this.mainHand : this.offHand;
        }

        public void add(int controller, int amount) {
            this.set(controller, this.get(controller) + amount);
        }

        public ItemStack getStack(int controller) {
            return controller == 0 ? this.stackHeldMain : this.stackHeldOff;
        }

        public void setStack(int controller, ItemStack stack) {
            if (controller == 0) {
                this.stackHeldMain = stack;
            } else {
                this.stackHeldOff = stack;
            }
        }

        public String toString() {
            return "Main Hand: " + this.stackHeldMain + " w/ " + this.mainHand + " ticks\nOff Hand: " + this.stackHeldOff + " w/ " + this.offHand + " ticks";
        }
    }
}

