/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server.tracker.vrhand;

import net.blf02.immersivemc.common.config.ServerPlayerConfig;
import net.blf02.immersivemc.server.data.LastTickData;
import net.blf02.immersivemc.server.tracker.ServerTrackerInit;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractVRHandTracker {
    public AbstractVRHandTracker() {
        ServerTrackerInit.vrPlayerTrackers.add(this);
    }

    protected abstract boolean shouldRunForHand(Player var1, InteractionHand var2, ItemStack var3, IVRPlayer var4, LastTickData var5);

    protected abstract void runForHand(Player var1, InteractionHand var2, ItemStack var3, IVRPlayer var4, LastTickData var5);

    public abstract boolean isEnabledInConfig(ServerPlayerConfig var1);

    public void preTick(Player player) {
    }

    public void tick(Player player, IVRPlayer currentVRData, LastTickData lastVRData) {
        for (InteractionHand hand : InteractionHand.values()) {
            if (!this.shouldRunForHand(player, hand, player.m_21120_(hand), currentVRData, lastVRData)) continue;
            this.runForHand(player, hand, player.m_21120_(hand), currentVRData, lastVRData);
        }
    }

    protected BlockPos getBlockPosAtHand(IVRPlayer vrPlayer, InteractionHand hand) {
        IVRData data = vrPlayer.getController(hand.ordinal());
        return new BlockPos(data.position());
    }

    protected BlockState getBlockStateAtHand(Player player, IVRPlayer vrPlayer, InteractionHand hand) {
        return player.f_19853_.m_8055_(this.getBlockPosAtHand(vrPlayer, hand));
    }

    protected Block getBlockAtHand(Player player, IVRPlayer vrPlayer, InteractionHand hand) {
        return this.getBlockStateAtHand(player, vrPlayer, hand).m_60734_();
    }

    protected boolean movingInDirectionWithThreshold(Direction direction, Vec3 handVelocity, double threshold) {
        Vec3i blockFacing = direction.m_122436_();
        if (this.signsMatch(blockFacing.m_123341_(), handVelocity.f_82479_) && blockFacing.m_123341_() != 0) {
            return Math.abs(handVelocity.f_82479_) >= threshold;
        }
        if (this.signsMatch(blockFacing.m_123342_(), handVelocity.f_82480_) && blockFacing.m_123342_() != 0) {
            return Math.abs(handVelocity.f_82480_) >= threshold;
        }
        if (this.signsMatch(blockFacing.m_123343_(), handVelocity.f_82481_) && blockFacing.m_123343_() != 0) {
            return Math.abs(handVelocity.f_82481_) >= threshold;
        }
        return false;
    }

    protected boolean signsMatch(double a, double b) {
        return a < 0.0 && b < 0.0 || a >= 0.0 && b >= 0.0;
    }
}

