/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server.tracker.vrhand;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.blf02.immersivemc.common.config.ServerPlayerConfig;
import net.blf02.immersivemc.server.data.LastTickData;
import net.blf02.immersivemc.server.tracker.vrhand.AbstractVRHandsTracker;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FeedAnimalsTracker
extends AbstractVRHandsTracker {
    public static final int COOLDOWN_TICKS = 20;
    protected Map<String, Integer> cooldown = new HashMap<String, Integer>();

    @Override
    public boolean isEnabledInConfig(ServerPlayerConfig config) {
        return config.canFeedAnimals;
    }

    @Override
    protected boolean shouldRun(Player player, IVRPlayer vrPlayer, LastTickData lastVRData) {
        int currentCooldown = this.cooldown.getOrDefault(player.m_36316_().getName(), 0);
        if (currentCooldown > 0) {
            this.cooldown.put(player.m_36316_().getName(), --currentCooldown);
        }
        return (!player.m_21120_(InteractionHand.MAIN_HAND).m_41619_() || !player.m_21120_(InteractionHand.OFF_HAND).m_41619_()) && currentCooldown <= 0;
    }

    @Override
    protected void run(Player player, IVRPlayer vrPlayer, LastTickData lastVRData) {
        InteractionHand hand = player.m_21120_(InteractionHand.MAIN_HAND).m_41619_() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack inHand = player.m_21120_(hand);
        if (inHand.m_41619_()) {
            return;
        }
        List<Animal> nearbyEnts = FeedAnimalsTracker.getLivingNearby(player);
        for (Animal animal : nearbyEnts) {
            InteractionResult res;
            AABB feedbox;
            if (!animal.m_6898_(inHand) || !(feedbox = FeedAnimalsTracker.getMouthHitbox((LivingEntity)animal)).m_82390_(vrPlayer.getController0().position()) || !feedbox.m_82390_(vrPlayer.getController1().position()) || !(vrPlayer.getController0().position().m_82557_(vrPlayer.getController1().position()) < 0.5) || (res = animal.m_6071_(player, hand)) != InteractionResult.CONSUME && res != InteractionResult.SUCCESS) continue;
            this.cooldown.put(player.m_36316_().getName(), 20);
            break;
        }
    }

    public static AABB getMouthHitbox(LivingEntity entity) {
        return AABB.m_165882_((Vec3)entity.m_146892_(), (double)((double)entity.m_20205_() * 2.25), (double)((double)entity.m_20206_() * 0.5), (double)((double)entity.m_20205_() * 2.25));
    }

    public static List<Animal> getLivingNearby(Player player) {
        AABB checkArea = AABB.m_165882_((Vec3)player.m_20182_(), (double)6.0, (double)6.0, (double)6.0);
        List ents = player.f_19853_.m_6249_((Entity)player, checkArea, e -> e instanceof Animal);
        LinkedList<Animal> nearby = new LinkedList<Animal>();
        for (Entity e2 : ents) {
            nearby.add((Animal)e2);
        }
        return nearby;
    }
}

