/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.immersivemc.server.tracker.vrhand;

import java.util.List;
import net.blf02.immersivemc.common.config.ServerPlayerConfig;
import net.blf02.immersivemc.server.LastTickVRData;
import net.blf02.immersivemc.server.data.LastTickData;
import net.blf02.immersivemc.server.tracker.vrhand.AbstractVRHandTracker;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class HoeTracker
extends AbstractVRHandTracker {
    public static final double THRESHOLD = 0.0575;

    @Override
    protected boolean shouldRunForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        return stackInHand.m_41720_() instanceof HoeItem;
    }

    @Override
    protected void runForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        Vec3 hit;
        BlockPos pos;
        IVRData handDataCurrent = currentVRData.getController(hand.ordinal());
        IVRData handDataLast = lastVRData.lastPlayer.getController(hand.ordinal());
        if (LastTickVRData.getAllVelocity(handDataLast, handDataCurrent, lastVRData) >= 0.0575 && !this.handleTill(player, hand, pos = new BlockPos(hit = handDataCurrent.position().m_82549_(handDataCurrent.getLookAngle().m_82542_(0.3333333333333333, 0.3333333333333333, 0.3333333333333333))))) {
            this.handleHarvest(player, pos, player.m_21120_(hand));
        }
    }

    protected boolean handleTill(Player player, InteractionHand hand, BlockPos pos) {
        boolean didTill;
        InteractionResult result = player.m_21120_(hand).m_41720_().m_6225_(new UseOnContext(player, hand, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.DOWN, pos, false)));
        boolean bl = didTill = result == InteractionResult.CONSUME || result == InteractionResult.SUCCESS;
        if (didTill) {
            player.f_19853_.m_5594_(null, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return didTill;
    }

    protected void handleHarvest(Player player, BlockPos pos, ItemStack hoe) {
        BlockState state = player.f_19853_.m_8055_(pos);
        if (state.m_60734_() == Blocks.f_50092_ && (Integer)state.m_61143_((Property)CropBlock.f_52244_) == 7) {
            List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)player.f_19853_), (BlockPos)pos, null, (Entity)player, (ItemStack)hoe);
            for (ItemStack d : drops) {
                if (d.m_41720_() == Items.f_42404_) {
                    d.m_41774_(1);
                }
                if (!d.m_41619_()) {
                    Vec3 dropPos = Vec3.m_82512_((Vec3i)pos);
                    ItemEntity drop = new ItemEntity(player.f_19853_, dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, d);
                    player.f_19853_.m_7967_((Entity)drop);
                }
                state = (BlockState)state.m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(0));
                player.f_19853_.m_7731_(pos, state, 2);
            }
        }
    }

    @Override
    public boolean isEnabledInConfig(ServerPlayerConfig config) {
        return config.useHoeImmersion;
    }
}

