/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.config.screen;

import com.hammy275.immersivemc.client.config.screen.ScreenUtils;
import com.hammy275.immersivemc.client.immersive.ImmersiveBackpack;
import com.hammy275.immersivemc.client.model.BackpackModel;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ImmersiveMCConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.time.Instant;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BackpackConfigScreen
extends Screen {
    protected final Screen parentScreen;
    protected OptionsList list;
    protected static int BUTTON_WIDTH = 128;
    protected static int BUTTON_HEIGHT = 20;

    public BackpackConfigScreen(Screen lastScreen) {
        super((Component)Component.m_237115_((String)"screen.immersivemc.backpack_config.title"));
        this.parentScreen = lastScreen;
    }

    protected void m_7856_() {
        this.list = new OptionsList(Minecraft.m_91087_(), this.f_96543_ / 2, this.f_96544_ / 2, 32, this.f_96544_ - 32, 24);
        this.initOptionsList();
        this.m_142416_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)new Button((this.f_96543_ - BUTTON_WIDTH) / 2, this.f_96544_ - 26, BUTTON_WIDTH, BUTTON_HEIGHT, (Component)Component.m_237115_((String)"gui.done"), button -> this.m_7379_()));
    }

    protected void initOptionsList() {
        this.list.m_232528_(ScreenUtils.createOption("left_handed_backpack", ImmersiveMCConfig.leftHandedBackpack));
        this.list.m_232528_(ScreenUtils.createOption("low_detail_backpack", ImmersiveMCConfig.useLowDetailBackpack));
        this.list.m_232528_(new OptionInstance("config.immersivemc.backpack_r", OptionInstance.m_231498_(), (component, integer) -> Component.m_237113_((String)(I18n.m_118938_((String)"config.immersivemc.backpack_r", (Object[])new Object[0]) + ": " + this.getRGB('r'))), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 255), (Object)this.getRGB('r'), newRVal -> this.setRGB((Integer)newRVal, 'r')));
        this.list.m_232528_(new OptionInstance("config.immersivemc.backpack_g", OptionInstance.m_231498_(), (component, integer) -> Component.m_237113_((String)(I18n.m_118938_((String)"config.immersivemc.backpack_g", (Object[])new Object[0]) + ": " + this.getRGB('g'))), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 255), (Object)this.getRGB('g'), newRVal -> this.setRGB((Integer)newRVal, 'g')));
        this.list.m_232528_(new OptionInstance("config.immersivemc.backpack_b", OptionInstance.m_231498_(), (component, integer) -> Component.m_237113_((String)(I18n.m_118938_((String)"config.immersivemc.backpack_b", (Object[])new Object[0]) + ": " + this.getRGB('b'))), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 255), (Object)this.getRGB('b'), newRVal -> this.setRGB((Integer)newRVal, 'b')));
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        BackpackConfigScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
        this.renderBackpack(stack);
        List list = OptionsSubScreen.m_96287_((OptionsList)this.list, (int)mouseX, (int)mouseY);
        if (list != null) {
            this.m_96617_(stack, list, mouseX, mouseY);
        }
    }

    protected void renderBackpack(PoseStack stack) {
        stack.m_85836_();
        Vector3f rgb = new Vector3f((float)(ActiveConfig.backpackColor >> 16), (float)(ActiveConfig.backpackColor >> 8 & 0xFF), (float)(ActiveConfig.backpackColor & 0xFF));
        rgb.m_122261_(0.003921569f);
        float size = 128.0f;
        stack.m_85837_((double)this.f_96543_ * 0.75, (double)((float)this.f_96544_ / 2.0f - size * 1.5f), 0.0);
        stack.m_85841_(size, size, size);
        stack.m_85845_(Vector3f.f_122222_.m_122240_(45.0f));
        long currentTimeMilli = Instant.now().toEpochMilli();
        long millisPerRot = 8000L;
        float rot = (float)(currentTimeMilli % millisPerRot) / (float)millisPerRot * ((float)Math.PI * 2);
        stack.m_85845_(Vector3f.f_122224_.m_122270_(rot));
        ImmersiveBackpack.getBackpackModel().m_7695_(stack, Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110452_((ResourceLocation)BackpackModel.textureLocation)), 0xF000F0, OverlayTexture.f_118083_, rgb.m_122239_(), rgb.m_122260_(), rgb.m_122269_(), 1.0f);
        Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
        stack.m_85849_();
    }

    public void m_7379_() {
        ImmersiveMCConfig.backpackColor.set((Object)ActiveConfig.backpackColor);
        ImmersiveMCConfig.backpackColor.save();
        Minecraft.m_91087_().m_91152_(this.parentScreen);
        ActiveConfig.loadConfigFromFile();
    }

    protected int getRGB(char type) {
        if (type == 'r') {
            return ActiveConfig.backpackColor >> 16;
        }
        if (type == 'g') {
            return ActiveConfig.backpackColor >> 8 & 0xFF;
        }
        return ActiveConfig.backpackColor & 0xFF;
    }

    protected void setRGB(Integer newVal, char type) {
        Vec3i rgb = new Vec3i(this.getRGB('r'), this.getRGB('g'), this.getRGB('b'));
        rgb = type == 'r' ? new Vec3i(newVal.intValue(), rgb.m_123342_(), rgb.m_123343_()) : (type == 'g' ? new Vec3i(rgb.m_123341_(), newVal.intValue(), rgb.m_123343_()) : new Vec3i(rgb.m_123341_(), rgb.m_123342_(), newVal.intValue()));
        ActiveConfig.backpackColor = (rgb.m_123341_() << 16) + (rgb.m_123342_() << 8) + rgb.m_123343_();
    }
}

