/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.client.immersive.AbstractBlockEntityImmersive;
import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.info.ImmersiveFurnaceInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.SwapPacket;
import com.hammy275.immersivemc.common.util.Util;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ImmersiveFurnace
extends AbstractBlockEntityImmersive<BlockEntity, ImmersiveFurnaceInfo> {
    public ImmersiveFurnace() {
        super(4);
    }

    @Override
    public ImmersiveFurnaceInfo getNewInfo(BlockEntity tileEnt) {
        return new ImmersiveFurnaceInfo(tileEnt, 80);
    }

    @Override
    public int getTickTime() {
        return 80;
    }

    @Override
    public boolean shouldRender(ImmersiveFurnaceInfo info, boolean isInVR) {
        Direction forward = info.forward;
        return forward != null && info.getBlockEntity().m_58904_() != null && info.getBlockEntity().m_58904_().m_8055_(info.getBlockEntity().m_58899_().m_121945_(forward)).m_60795_() && info.readyToRender();
    }

    @Override
    protected void doTick(ImmersiveFurnaceInfo info, boolean isInVR) {
        Vec3 posOutput;
        Vec3 posToSmelt;
        Vec3 posFuel;
        super.doTick(info, isInVR);
        Object furnace = info.getBlockEntity();
        Direction forward = (Direction)furnace.m_58900_().m_61143_((Property)AbstractFurnaceBlock.f_48683_);
        Vec3 pos = this.getDirectlyInFront(forward, furnace.m_58899_());
        Direction left = this.getLeftOfDirection(forward);
        Vec3 toSmeltAndFuelOffset = new Vec3((double)left.m_122436_().m_123341_() * 0.25, 0.0, (double)left.m_122436_().m_123343_() * 0.25);
        Vec3 outputOffset = new Vec3((double)left.m_122436_().m_123341_() * 0.75, 0.0, (double)left.m_122436_().m_123343_() * 0.75);
        if (ActiveConfig.autoCenterFurnace) {
            posFuel = pos.m_82520_((double)left.m_122436_().m_123341_() * 0.5, 0.25, (double)left.m_122436_().m_123343_() * 0.5);
            if (info.items[2] == null || info.items[2].m_41619_()) {
                posToSmelt = posFuel.m_82520_(0.0, 0.5, 0.0);
                posOutput = null;
            } else if (info.items[0] == null || info.items[0].m_41619_()) {
                posOutput = posFuel.m_82520_(0.0, 0.5, 0.0);
                posToSmelt = null;
            } else {
                posToSmelt = pos.m_82549_(toSmeltAndFuelOffset).m_82520_(0.0, 0.75, 0.0);
                posOutput = pos.m_82549_(outputOffset).m_82520_(0.0, 0.75, 0.0);
            }
        } else {
            posToSmelt = pos.m_82520_(0.0, 0.75, 0.0).m_82549_(toSmeltAndFuelOffset);
            posFuel = pos.m_82520_(0.0, 0.25, 0.0).m_82549_(toSmeltAndFuelOffset);
            posOutput = pos.m_82520_(0.0, 0.5, 0.0).m_82549_(outputOffset);
        }
        info.setPosition(0, posToSmelt);
        info.setPosition(1, posFuel);
        info.setPosition(2, posOutput);
        if (posToSmelt != null) {
            info.setHitbox(0, this.createHitbox(posToSmelt, 0.16666667f));
        } else {
            info.setHitbox(0, null);
        }
        info.setHitbox(1, this.createHitbox(posFuel, 0.16666667f));
        if (posOutput != null) {
            info.setHitbox(2, this.createHitbox(posOutput, 0.16666667f));
        } else {
            info.setHitbox(2, null);
        }
    }

    @Override
    protected void render(ImmersiveFurnaceInfo info, PoseStack stack, boolean isInVR) {
        float size = 0.5f / (float)info.getItemTransitionCountdown();
        this.renderItem(info.items[0], stack, info.getPosition(0), info.slotHovered == 0 ? size * 1.25f : size, info.forward, info.getHitbox(0), true);
        this.renderItem(info.items[1], stack, info.getPosition(1), info.slotHovered == 1 ? size * 1.25f : size, info.forward, info.getHitbox(1), true);
        if (info.items[2] != null && !info.items[2].m_41619_()) {
            this.renderItem(info.items[2], stack, info.getPosition(2), info.slotHovered == 2 ? size * 1.25f : size, info.forward, info.getHitbox(2), true);
        }
    }

    @Override
    protected boolean enabledInConfig() {
        return ActiveConfig.useFurnaceImmersion;
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isFurnace(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveFurnace;
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int slot, InteractionHand hand) {
        ItemStack handItem;
        ImmersiveFurnaceInfo infoF = (ImmersiveFurnaceInfo)info;
        if (!(info.getPosition(0) != null || slot != 2 || (handItem = player.m_21120_(hand)).m_41619_() || Util.stacksEqualBesidesCount(handItem, infoF.items[2]) && handItem.m_41613_() != handItem.m_41741_())) {
            slot = 0;
        }
        Network.INSTANCE.sendToServer((Object)new SwapPacket(infoF.getBlockEntity().m_58899_(), slot, hand));
    }

    @Override
    protected void initInfo(ImmersiveFurnaceInfo info) {
    }
}

